/*
 * Decompiled with CFR 0.152.
 */
package swim.remote;

import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import swim.api.auth.Identity;
import swim.concurrent.PullContext;
import swim.concurrent.PullRequest;
import swim.remote.RemoteHost;
import swim.runtime.CellContext;
import swim.runtime.LinkBinding;
import swim.runtime.LinkContext;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.Envelope;
import swim.warp.LinkRequest;
import swim.warp.SyncRequest;

final class RemoteHostDownlink
implements LinkBinding,
PullRequest<Envelope> {
    final RemoteHost host;
    final Uri remoteNodeUri;
    final Uri nodeUri;
    final Uri laneUri;
    final float prio;
    final float rate;
    final Value body;
    final ConcurrentLinkedQueue<Envelope> upQueue;
    LinkContext linkContext;
    PullContext<? super Envelope> pullContext;
    volatile int status;
    static final int FEEDING_DOWN = 1;
    static final int PULLING_DOWN = 2;
    static final int FEEDING_UP = 4;
    static final int SYNC = 8;
    static final AtomicIntegerFieldUpdater<RemoteHostDownlink> STATUS = AtomicIntegerFieldUpdater.newUpdater(RemoteHostDownlink.class, "status");

    RemoteHostDownlink(RemoteHost host, Uri remoteNodeUri, Uri nodeUri, Uri laneUri, float prio, float rate, Value body) {
        this.host = host;
        this.remoteNodeUri = remoteNodeUri;
        this.nodeUri = nodeUri;
        this.laneUri = laneUri;
        this.prio = prio;
        this.rate = rate;
        this.body = body;
        this.upQueue = new ConcurrentLinkedQueue();
    }

    public LinkContext linkContext() {
        return this.linkContext;
    }

    public void setLinkContext(LinkContext linkContext) {
        this.linkContext = linkContext;
    }

    public CellContext cellContext() {
        return null;
    }

    public void setCellContext(CellContext cellContext) {
    }

    public <T> T unwrapLink(Class<T> linkClass) {
        if (linkClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    public Uri meshUri() {
        return Uri.empty();
    }

    public Uri hostUri() {
        return Uri.empty();
    }

    public Uri nodeUri() {
        return this.nodeUri;
    }

    public Uri laneUri() {
        return this.laneUri;
    }

    public float prio() {
        return this.prio;
    }

    public float rate() {
        return this.rate;
    }

    public Value body() {
        return this.body;
    }

    public boolean keepLinked() {
        return false;
    }

    public boolean keepSynced() {
        return false;
    }

    public boolean isConnectedDown() {
        return this.host.isConnected();
    }

    public boolean isRemoteDown() {
        return this.host.isRemote();
    }

    public boolean isSecureDown() {
        return this.host.isSecure();
    }

    public String securityProtocolDown() {
        return this.host.securityProtocol();
    }

    public String cipherSuiteDown() {
        return this.host.cipherSuite();
    }

    public InetSocketAddress localAddressDown() {
        return this.host.localAddress();
    }

    public Identity localIdentityDown() {
        return this.host.localIdentity();
    }

    public Principal localPrincipalDown() {
        return this.host.localPrincipal();
    }

    public Collection<Certificate> localCertificatesDown() {
        return this.host.localCertificates();
    }

    public InetSocketAddress remoteAddressDown() {
        return this.host.remoteAddress();
    }

    public Identity remoteIdentityDown() {
        return this.host.remoteIdentity();
    }

    public Principal remotePrincipalDown() {
        return this.host.remotePrincipal();
    }

    public Collection<Certificate> remoteCertificatesDown() {
        return this.host.remoteCertificates();
    }

    public void feedDown() {
        int newStatus;
        int oldStatus;
        while (oldStatus != (newStatus = ((oldStatus = this.status) & 2) == 0 ? oldStatus & 0xFFFFFFFE | 2 : oldStatus | 1) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if ((oldStatus & 2) == 0) {
            this.host.warpSocketContext.feed((PullRequest)this);
        }
    }

    public void pull(PullContext<? super Envelope> pullContext) {
        this.pullContext = pullContext;
        this.linkContext.pullDown();
    }

    public void pushDown(Envelope envelope) {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus & 0xFFFFFFFD) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if (oldStatus != newStatus) {
            Envelope remoteEnvelope = envelope.nodeUri(this.remoteNodeUri);
            this.pullContext.push((Object)remoteEnvelope);
            this.pullContext = null;
        }
    }

    public void skipDown() {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = oldStatus & 0xFFFFFFFD) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if (oldStatus != newStatus) {
            this.pullContext.skip();
            this.pullContext = null;
        }
    }

    public void queueUp(Envelope envelope) {
        int newStatus;
        int oldStatus;
        this.upQueue.add(envelope);
        do {
            oldStatus = this.status;
            newStatus = oldStatus | 4;
            if (!(envelope instanceof SyncRequest)) continue;
            newStatus |= 8;
        } while (oldStatus != newStatus && !STATUS.compareAndSet(this, oldStatus, newStatus));
        if ((oldStatus & 4) != (newStatus & 4)) {
            this.linkContext.feedUp();
        }
    }

    public void pullUp() {
        int newStatus;
        int oldStatus;
        Envelope envelope = this.upQueue.poll();
        while ((oldStatus = this.status) != (newStatus = oldStatus & 0xFFFFFFFB) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if (envelope != null) {
            this.linkContext.pushUp(envelope);
        }
        this.feedUpQueue();
    }

    void feedUpQueue() {
        int newStatus;
        int oldStatus;
        while ((oldStatus = this.status) != (newStatus = !this.upQueue.isEmpty() ? oldStatus | 4 : oldStatus) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        if (oldStatus != newStatus) {
            this.linkContext.feedUp();
        }
    }

    public void reopen() {
        int newStatus;
        int oldStatus;
        this.linkContext.closeUp();
        while ((oldStatus = this.status) != (newStatus = oldStatus & 0xFFFFFFFB) && !STATUS.compareAndSet(this, oldStatus, newStatus)) {
        }
        this.host.hostContext.openDownlink((LinkBinding)this);
        this.linkContext.didOpenDown();
        Object request = (oldStatus & 8) != 0 ? new SyncRequest(this.nodeUri, this.laneUri, this.prio, this.rate, this.body) : new LinkRequest(this.nodeUri, this.laneUri, this.prio, this.rate, this.body);
        this.queueUp((Envelope)request);
    }

    public void openDown() {
        this.linkContext.didOpenDown();
    }

    public void closeDown() {
        this.linkContext.didCloseDown();
    }

    public void didConnect() {
    }

    public void didDisconnect() {
    }

    public void didCloseUp() {
    }

    public void didFail(Throwable error) {
        error.printStackTrace();
    }

    public void traceDown(Object message) {
        this.host.trace(message);
    }

    public void debugDown(Object message) {
        this.host.debug(message);
    }

    public void infoDown(Object message) {
        this.host.info(message);
    }

    public void warnDown(Object message) {
        this.host.warn(message);
    }

    public void errorDown(Object message) {
        this.host.error(message);
    }
}

