/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.agent;

import swim.api.Link;
import swim.api.SwimContext;
import swim.api.agent.Agent;
import swim.api.agent.AgentContext;
import swim.api.agent.AgentFactory;
import swim.api.agent.AgentType;
import swim.api.data.ListData;
import swim.api.data.MapData;
import swim.api.data.SpatialData;
import swim.api.data.ValueData;
import swim.api.downlink.Downlink;
import swim.api.lane.CommandLane;
import swim.api.lane.DemandLane;
import swim.api.lane.DemandMapLane;
import swim.api.lane.JoinMapLane;
import swim.api.lane.JoinValueLane;
import swim.api.lane.Lane;
import swim.api.lane.ListLane;
import swim.api.lane.MapLane;
import swim.api.lane.SpatialLane;
import swim.api.lane.SupplyLane;
import swim.api.lane.ValueLane;
import swim.api.policy.Policy;
import swim.collections.FingerTrieSeq;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.math.R2Shape;
import swim.math.Z2Form;
import swim.runtime.AbstractTierBinding;
import swim.runtime.HttpBinding;
import swim.runtime.LinkBinding;
import swim.runtime.PushRequest;
import swim.runtime.TierContext;
import swim.runtime.agent.AgentClass;
import swim.runtime.agent.AgentModel;
import swim.runtime.lane.CommandLaneView;
import swim.runtime.lane.DemandLaneView;
import swim.runtime.lane.DemandMapLaneView;
import swim.runtime.lane.JoinMapLaneView;
import swim.runtime.lane.JoinValueLaneView;
import swim.runtime.lane.LaneView;
import swim.runtime.lane.ListLaneView;
import swim.runtime.lane.MapLaneView;
import swim.runtime.lane.SpatialLaneView;
import swim.runtime.lane.SupplyLaneView;
import swim.runtime.lane.ValueLaneView;
import swim.spatial.GeoProjection;
import swim.store.StoreBinding;
import swim.structure.Text;
import swim.structure.Value;
import swim.uri.Uri;
import swim.util.Builder;

public class AgentView
extends AbstractTierBinding
implements TierContext,
AgentContext {
    protected final AgentModel node;
    protected final Value props;
    protected Agent agent;

    public AgentView(AgentModel node, Value props) {
        this.node = node;
        this.props = props.commit();
    }

    public final Agent agent() {
        return this.agent;
    }

    void setAgent(Agent agent) {
        this.agent = agent;
    }

    @Override
    public TierContext tierContext() {
        return this;
    }

    public <T> T unwrapNode(Class<T> nodeClass) {
        if (nodeClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (nodeClass.isAssignableFrom(this.agent.getClass())) {
            return (T)this.agent;
        }
        return null;
    }

    @Override
    public final Uri meshUri() {
        return this.node.meshUri();
    }

    public final Uri hostUri() {
        return this.node.hostUri();
    }

    public final Uri nodeUri() {
        return this.node.nodeUri();
    }

    public final AgentType<?> agentType() {
        return this.node.agentType();
    }

    public final Value props() {
        return this.props;
    }

    public Value getProp(Value key) {
        return this.props.get(key);
    }

    public Value getProp(String name) {
        return this.props.get(name);
    }

    @Override
    public Policy policy() {
        return this.node.policy();
    }

    @Override
    public Schedule schedule() {
        return this.node.schedule();
    }

    @Override
    public Stage stage() {
        return this.node.stage();
    }

    @Override
    public StoreBinding store() {
        return this.node.store();
    }

    public Lane lane() {
        return SwimContext.getLane();
    }

    public Link link() {
        return SwimContext.getLink();
    }

    public FingerTrieSeq<Agent> traits() {
        Object views = this.node.views;
        Builder traits = FingerTrieSeq.builder();
        if (views instanceof AgentView) {
            traits.add((Object)((AgentView)views).agent);
        } else if (views instanceof AgentView[]) {
            AgentView[] viewArray = (AgentView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                traits.add((Object)viewArray[i].agent);
            }
        }
        return (FingerTrieSeq)traits.bind();
    }

    public <S extends Agent> S getTrait(Value props) {
        AgentView view = this.node.getAgentView(props);
        if (view != null) {
            return (S)view.agent;
        }
        return null;
    }

    public <S extends Agent> S getTrait(String name) {
        return this.getTrait((Value)Text.from((String)name));
    }

    public <S extends Agent> S getTrait(Class<S> agentClass) {
        return this.node.getTrait(agentClass);
    }

    public <S extends Agent> S addTrait(Value props, AgentFactory<S> agentFactory) {
        return this.node.addTrait(props, agentFactory);
    }

    public <S extends Agent> S addTrait(String name, AgentFactory<S> agentFactory) {
        return this.addTrait((Value)Text.from((String)name), agentFactory);
    }

    public <S extends Agent> S addTrait(Value props, Class<S> agentClass) {
        return this.addTrait(props, (AgentFactory<S>)AgentClass.apply(agentClass));
    }

    public <S extends Agent> S addTrait(String name, Class<S> agentClass) {
        return this.addTrait((Value)Text.from((String)name), agentClass);
    }

    public void removeTrait(Value props) {
        AgentView view = this.node.getAgentView(props);
        if (view != null) {
            this.node.removeAgentView(view);
        }
    }

    public void removeTrait(String name) {
        this.removeTrait((Value)Text.from((String)name));
    }

    public Lane getLane(Uri laneUri) {
        return this.node.getLane(laneUri).getLaneView(this);
    }

    public Lane openLane(Uri laneUri, Lane lane) {
        this.node.openLaneView(laneUri, (LaneView)lane);
        return lane;
    }

    public <V> CommandLane<V> commandLane() {
        return new CommandLaneView(this, null);
    }

    public <V> DemandLane<V> demandLane() {
        return new DemandLaneView(this, null);
    }

    public <K, V> DemandMapLane<K, V> demandMapLane() {
        return new DemandMapLaneView(this, null, null);
    }

    public <L, K, V> JoinMapLane<L, K, V> joinMapLane() {
        return new JoinMapLaneView(this, null, null, null);
    }

    public <K, V> JoinValueLane<K, V> joinValueLane() {
        return new JoinValueLaneView(this, null, null);
    }

    public <V> ListLane<V> listLane() {
        return new ListLaneView(this, null);
    }

    public <K, V> MapLane<K, V> mapLane() {
        return new MapLaneView(this, null, null);
    }

    public <K, S, V> SpatialLane<K, S, V> spatialLane(Z2Form<S> shapeForm) {
        return new SpatialLaneView(this, null, shapeForm, null);
    }

    public <K, V> SpatialLane<K, R2Shape, V> geospatialLane() {
        return new SpatialLaneView(this, null, GeoProjection.wgs84Form(), null);
    }

    public <V> SupplyLane<V> supplyLane() {
        return new SupplyLaneView(this, null);
    }

    public <V> ValueLane<V> valueLane() {
        return new ValueLaneView(this, null);
    }

    public ListData<Value> listData(Value name) {
        return this.store().listData(name);
    }

    public ListData<Value> listData(String name) {
        return this.store().listData(name);
    }

    public MapData<Value, Value> mapData(Value name) {
        return this.store().mapData(name);
    }

    public MapData<Value, Value> mapData(String name) {
        return this.store().mapData(name);
    }

    public <S> SpatialData<Value, S, Value> spatialData(Value name, Z2Form<S> shapeForm) {
        return this.store().spatialData(name, shapeForm);
    }

    public <S> SpatialData<Value, S, Value> spatialData(String name, Z2Form<S> shapeForm) {
        return this.store().spatialData(name, shapeForm);
    }

    public SpatialData<Value, R2Shape, Value> geospatialData(Value name) {
        return this.store().geospatialData(name);
    }

    public SpatialData<Value, R2Shape, Value> geospatialData(String name) {
        return this.store().geospatialData(name);
    }

    public ValueData<Value> valueData(Value name) {
        return this.store().valueData(name);
    }

    public ValueData<Value> valueData(String name) {
        return this.store().valueData(name);
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        return this.node.bindDownlink(downlink);
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.node.openDownlink(link);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
        this.node.closeDownlink(link);
    }

    @Override
    public void httpDownlink(HttpBinding http) {
        this.node.httpDownlink(http);
    }

    @Override
    public void pushDown(PushRequest pushRequest) {
        this.node.pushDown(pushRequest);
    }

    public void trace(Object message) {
        this.node.trace(message);
    }

    public void debug(Object message) {
        this.node.debug(message);
    }

    public void info(Object message) {
        this.node.info(message);
    }

    public void warn(Object message) {
        this.node.warn(message);
    }

    public void error(Object message) {
        this.node.error(message);
    }

    @Override
    public void willOpen() {
        this.agent.willOpen();
    }

    @Override
    public void didOpen() {
        this.agent.didOpen();
    }

    @Override
    public void willLoad() {
        this.agent.willLoad();
    }

    @Override
    public void didLoad() {
        this.agent.didLoad();
    }

    @Override
    public void willStart() {
        this.agent.willStart();
    }

    @Override
    public void didStart() {
        this.agent.didStart();
    }

    @Override
    public void willStop() {
        this.agent.willStop();
    }

    @Override
    public void didStop() {
        this.agent.didStop();
    }

    @Override
    public void willUnload() {
        this.agent.willUnload();
    }

    @Override
    public void didUnload() {
        this.agent.didUnload();
    }

    @Override
    public void willClose() {
        this.agent.willClose();
        this.node.close();
    }

    @Override
    public void didClose() {
        this.agent.didClose();
    }

    @Override
    public void didFail(Throwable error) {
        this.agent.didFail(error);
    }
}

