/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import swim.runtime.downlink.DownlinkRelay;
import swim.runtime.downlink.ListDownlinkModel;
import swim.runtime.downlink.ListDownlinkView;
import swim.structure.Record;
import swim.structure.Value;
import swim.warp.EventMessage;

final class ListDownlinkRelayClear
extends DownlinkRelay<ListDownlinkModel, ListDownlinkView<?>> {
    final EventMessage message;

    ListDownlinkRelayClear(ListDownlinkModel model, EventMessage message) {
        super(model, 0, 3);
        this.message = message;
    }

    ListDownlinkRelayClear(ListDownlinkModel model) {
        super(model, 3, 4);
        this.message = null;
    }

    @Override
    void beginPhase(int phase) {
        if (phase == 2 && ((ListDownlinkModel)this.model).isStateful()) {
            ((ListDownlinkModel)this.model).state.clear();
        }
    }

    @Override
    boolean runPhase(ListDownlinkView<?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.downlinkWillReceive(this.message);
            }
            return view.dispatchWillReceive(this.message.body(), preemptive);
        }
        if (phase == 1) {
            if (preemptive) {
                view.downlinkWillClear();
            }
            return view.dispatchWillClear(preemptive);
        }
        if (phase == 2) {
            if (preemptive) {
                view.downlinkDidClear();
            }
            return view.dispatchDidClear(preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.downlinkDidReceive(this.message);
            }
            return view.dispatchDidReceive(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    void done() {
        if (this.message != null) {
            ((ListDownlinkModel)this.model).cueDown();
        } else {
            ((ListDownlinkModel)this.model).pushUp((Value)Record.create((int)1).attr("clear"));
        }
    }
}

