/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import swim.api.data.ListData;
import swim.runtime.LaneContext;
import swim.runtime.LinkBinding;
import swim.runtime.lane.LaneModel;
import swim.runtime.lane.LaneView;
import swim.runtime.lane.ListLaneRelayClear;
import swim.runtime.lane.ListLaneRelayDrop;
import swim.runtime.lane.ListLaneRelayMove;
import swim.runtime.lane.ListLaneRelayRemove;
import swim.runtime.lane.ListLaneRelayTake;
import swim.runtime.lane.ListLaneRelayUpdate;
import swim.runtime.lane.ListLaneUplink;
import swim.runtime.lane.ListLaneView;
import swim.runtime.lane.ValueLaneView;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.warp.CommandMessage;

public class ListLaneModel
extends LaneModel<ListLaneView<?>, ListLaneUplink> {
    protected int flags;
    protected ListData<Value> data;
    static final int RESIDENT = 1;
    static final int TRANSIENT = 2;
    static final int SIGNED = 4;

    ListLaneModel(int flags) {
        this.flags = flags;
    }

    public ListLaneModel() {
        this(0);
    }

    @Override
    protected ListLaneUplink createUplink(LinkBinding link) {
        return new ListLaneUplink(this, link);
    }

    @Override
    public void setLaneContext(LaneContext laneContext) {
        super.setLaneContext(laneContext);
        this.openStore();
    }

    protected void openStore() {
        this.data = this.laneContext.store().listData(this.laneUri().toString()).isResident(this.isResident()).isTransient(this.isTransient());
    }

    @Override
    protected void didOpenLaneView(ListLaneView<?> view) {
        view.setLaneBinding(this);
    }

    @Override
    public void onCommand(CommandMessage message) {
        Value payload = message.body();
        String tag = payload.tag();
        if ("update".equals(tag)) {
            Value header = payload.header("update");
            int index = header.get("index").intValue(-1);
            if (index > -1) {
                Value key = header.get("key").isDefined() ? header.get("key") : null;
                Value value = payload.body();
                new ListLaneRelayUpdate(this, null, message, index, value, key).run();
            }
        } else if ("move".equals(tag)) {
            Value header = payload.header("move");
            int fromIndex = header.get("from").intValue(-1);
            int toIindex = header.get("to").intValue(-1);
            if (fromIndex > -1 && toIindex > -1) {
                Value key = header.get("key").isDefined() ? header.get("key") : null;
                new ListLaneRelayMove(this, null, message, fromIndex, toIindex, key).run();
            }
        } else if ("remove".equals(tag)) {
            Value header = payload.header("remove");
            int index = header.get("index").intValue(-1);
            if (index > -1) {
                Value key = header.get("key").isDefined() ? header.get("key") : null;
                new ListLaneRelayRemove(this, null, message, index, key).run();
            }
        } else if ("drop".equals(tag)) {
            Value header = payload.header("drop");
            int lower = header.intValue(0);
            new ListLaneRelayDrop(this, null, message, lower).run();
        } else if ("take".equals(tag)) {
            Value header = payload.header("take");
            int upper = header.intValue(0);
            new ListLaneRelayTake(this, null, message, upper).run();
        } else if ("clear".equals(tag)) {
            new ListLaneRelayClear(this, null, message).run();
        }
    }

    public final boolean isResident() {
        return (this.flags & 1) != 0;
    }

    public ListLaneModel isResident(boolean isResident) {
        if (this.data != null) {
            this.data.isResident(isResident);
        }
        this.flags = isResident ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        Object views = this.views;
        if (views instanceof ValueLaneView) {
            ((ValueLaneView)views).didSetResident(isResident);
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((ValueLaneView)viewArray[i]).didSetResident(isResident);
            }
        }
        return this;
    }

    public final boolean isTransient() {
        return (this.flags & 2) != 0;
    }

    public ListLaneModel isTransient(boolean isTransient) {
        if (this.data != null) {
            this.data.isTransient(isTransient);
        }
        this.flags = isTransient ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
        Object views = this.views;
        if (views instanceof ValueLaneView) {
            ((ValueLaneView)views).didSetTransient(isTransient);
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((ValueLaneView)viewArray[i]).didSetTransient(isTransient);
            }
        }
        return this;
    }

    public final boolean isSigned() {
        return (this.flags & 4) != 0;
    }

    public ListLaneModel isSigned(boolean isSigned) {
        this.flags = isSigned ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
        Object views = this.views;
        if (views instanceof ListLaneView) {
            ((ListLaneView)views).didSetSigned(isSigned);
        } else if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                ((ListLaneView)viewArray[i]).didSetSigned(isSigned);
            }
        }
        return this;
    }

    public Value get(int index) {
        return (Value)this.data.get(index);
    }

    public <V> boolean add(ListLaneView<V> view, int index, V newObject) {
        return this.add(view, index, newObject, null);
    }

    public <V> boolean add(ListLaneView<V> view, int index, V newObject, Object key) {
        Form valueForm = view.valueForm;
        Value newValue = valueForm.mold(newObject).toValue();
        ListLaneRelayUpdate relay = new ListLaneRelayUpdate(this, null, index, newValue, key);
        relay.valueForm = valueForm;
        relay.newObject = newObject;
        relay.stage = this.stage();
        relay.run();
        return relay.newObject != null;
    }

    public <V> V set(ListLaneView<V> view, int index, V newObject) {
        return this.set(view, index, newObject, null);
    }

    public <V> V set(ListLaneView<V> view, int index, V newObject, Object key) {
        Form valueForm = view.valueForm;
        Value newValue = valueForm.mold(newObject).toValue();
        ListLaneRelayUpdate relay = new ListLaneRelayUpdate(this, null, index, newValue, key);
        relay.valueForm = valueForm;
        relay.oldObject = newObject;
        relay.newObject = newObject;
        relay.stage = this.stage();
        relay.run();
        if (relay.valueForm != valueForm && valueForm != null) {
            relay.oldObject = valueForm.cast((Item)relay.oldValue);
            if (relay.oldObject == null) {
                relay.oldObject = valueForm.unit();
            }
        }
        return (V)relay.oldObject;
    }

    public void move(int fromIndex, int toIndex) {
        this.move(fromIndex, toIndex, null);
    }

    public void move(int fromIndex, int toIndex, Object key) {
        ListLaneRelayMove relay = new ListLaneRelayMove(this, null, fromIndex, toIndex, key);
        relay.stage = this.stage();
        relay.run();
    }

    public <V> V remove(ListLaneView<V> view, int index) {
        return this.remove(view, index, null);
    }

    public <V> V remove(ListLaneView<V> view, int index, Object key) {
        Form valueForm = view.valueForm;
        ListLaneRelayRemove relay = new ListLaneRelayRemove(this, null, index, key);
        relay.valueForm = valueForm;
        relay.stage = this.stage();
        relay.run();
        if (relay.valueForm != valueForm && valueForm != null) {
            relay.oldObject = valueForm.cast((Item)relay.oldValue);
            if (relay.oldObject == null) {
                relay.oldObject = valueForm.unit();
            }
        }
        return (V)relay.oldObject;
    }

    public void drop(ListLaneView<?> view, int lower) {
        ListLaneRelayDrop relay = new ListLaneRelayDrop(this, null, lower);
        relay.stage = this.stage();
        relay.run();
    }

    public void take(ListLaneView<?> view, int upper) {
        ListLaneRelayTake relay = new ListLaneRelayTake(this, null, upper);
        relay.stage = this.stage();
        relay.run();
    }

    public void clear(ListLaneView<?> view) {
        ListLaneRelayClear relay = new ListLaneRelayClear(this, null);
        relay.stage = this.stage();
        relay.run();
    }
}

