/*
 * Decompiled with CFR 0.152.
 */
package swim.spatial;

import java.util.Map;
import swim.spatial.SpatialMap;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;

public final class SpatialValueEntry<K, S, V>
implements SpatialMap.Entry<K, S, V> {
    final SpatialMap.Entry<Value, S, Value> inner;
    final Form<K> keyForm;
    final Form<V> valueForm;
    volatile K keyObject;
    volatile V valueObject;

    public SpatialValueEntry(SpatialMap.Entry<Value, S, Value> inner, Form<K> keyForm, Form<V> valueForm) {
        this.inner = inner;
        this.keyForm = keyForm;
        this.valueForm = valueForm;
    }

    @Override
    public K getKey() {
        Object keyObject = this.keyObject;
        if (keyObject == null) {
            keyObject = this.keyForm.cast((Item)this.inner.getKey());
            if (keyObject == null) {
                keyObject = this.keyForm.unit();
            }
            this.keyObject = keyObject;
        }
        return keyObject;
    }

    @Override
    public S getShape() {
        return this.inner.getShape();
    }

    @Override
    public V getValue() {
        Object valueObject = this.valueObject;
        if (valueObject == null) {
            valueObject = this.valueForm.cast((Item)this.inner.getValue());
            if (valueObject == null) {
                valueObject = this.valueForm.unit();
            }
            this.valueObject = valueObject;
        }
        return valueObject;
    }

    @Override
    public V setValue(V newValueObject) {
        Value newValue = this.valueForm.mold(newValueObject).toValue();
        Value oldValue = this.inner.setValue(newValue);
        Object oldValueObject = this.valueForm.cast((Item)oldValue);
        if (oldValueObject != null) {
            return (V)oldValueObject;
        }
        return (V)this.valueForm.unit();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Map.Entry) {
            Map.Entry that = (Map.Entry)other;
            K keyObject = this.getKey();
            if (keyObject == null ? that.getKey() != null : !keyObject.equals(that.getKey())) {
                return false;
            }
            V valueObject = this.getValue();
            return !(valueObject == null ? that.getValue() != null : !valueObject.equals(that.getValue()));
        }
        return false;
    }

    @Override
    public int hashCode() {
        K keyObject = this.getKey();
        V valueObject = this.getValue();
        return (keyObject == null ? 0 : keyObject.hashCode()) ^ (valueObject == null ? 0 : valueObject.hashCode());
    }

    public String toString() {
        return "" + this.getKey() + '=' + this.getValue();
    }
}

