/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Encoder;
import swim.codec.OutputBuffer;
import swim.collections.FingerTrieSeq;
import swim.http.Http;
import swim.http.HttpEmpty;
import swim.http.HttpHeader;
import swim.http.HttpMessage;
import swim.http.HttpWriter;
import swim.http.MediaType;
import swim.http.TransferCoding;

public abstract class HttpEntity<T> {
    private static HttpEntity<Object> empty;

    public abstract boolean isDefined();

    public abstract T get();

    public abstract long length();

    public abstract MediaType mediaType();

    public abstract FingerTrieSeq<TransferCoding> transferCodings();

    public abstract FingerTrieSeq<HttpHeader> headers();

    public abstract <T2> Encoder<?, HttpMessage<T2>> httpEncoder(HttpMessage<T2> var1, HttpWriter var2);

    public <T2> Encoder<?, HttpMessage<T2>> httpEncoder(HttpMessage<T2> message) {
        return this.httpEncoder(message, Http.standardWriter());
    }

    public abstract <T2> Encoder<?, HttpMessage<T2>> encodeHttp(HttpMessage<T2> var1, OutputBuffer<?> var2, HttpWriter var3);

    public <T2> Encoder<?, HttpMessage<T2>> encodeHttp(HttpMessage<T2> message, OutputBuffer<?> output) {
        return this.encodeHttp(message, output, Http.standardWriter());
    }

    public static <T> HttpEntity<T> empty() {
        if (empty == null) {
            empty = new HttpEmpty();
        }
        return empty;
    }
}

