/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.recon.ReconWriter;

final class AttrWriter<I, V>
extends Writer<Object, Object> {
    final ReconWriter<I, V> recon;
    final V key;
    final V value;
    final Writer<?, ?> part;
    final int step;

    AttrWriter(ReconWriter<I, V> recon, V key, V value, Writer<?, ?> part, int step) {
        this.recon = recon;
        this.key = key;
        this.value = value;
        this.part = part;
        this.step = step;
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return AttrWriter.write(output, this.recon, this.key, this.value, this.part, this.step);
    }

    static <I, V> int sizeOf(ReconWriter<I, V> recon, V key, V value) {
        int size = 0;
        ++size;
        size += recon.sizeOfValue(key);
        if (!recon.isExtant(recon.item(value))) {
            ++size;
            size += recon.sizeOfBlockValue(value);
            ++size;
        }
        return size;
    }

    static <I, V> Writer<Object, Object> write(Output<?> output, ReconWriter<I, V> recon, V key, V value, Writer<?, ?> part, int step) {
        if (step == 1 && output.isCont()) {
            output = output.write(64);
            step = 2;
        }
        if (step == 2) {
            if ((part = part == null ? recon.writeValue(key, output) : part.pull(output)).isDone()) {
                part = null;
                if (recon.isExtant(recon.item(value))) {
                    return AttrWriter.done();
                }
                step = 3;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 3 && output.isCont()) {
            output = output.write(40);
            step = 4;
        }
        if (step == 4) {
            if ((part = part == null ? recon.writeBlockValue(value, output) : part.pull(output)).isDone()) {
                part = null;
                step = 5;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 5 && output.isCont()) {
            output = output.write(41);
            return AttrWriter.done();
        }
        if (output.isDone()) {
            return AttrWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return AttrWriter.error((Throwable)output.trap());
        }
        return new AttrWriter<I, V>(recon, key, value, part, step);
    }

    static <I, V> Writer<Object, Object> write(Output<?> output, ReconWriter<I, V> recon, V key, V value) {
        return AttrWriter.write(output, recon, key, value, null, 1);
    }
}

