/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.recon.ReconWriter;

final class InvokeOperatorWriter<I, V>
extends Writer<Object, Object> {
    final ReconWriter<I, V> recon;
    final V func;
    final V args;
    final Writer<?, ?> part;
    final int step;

    InvokeOperatorWriter(ReconWriter<I, V> recon, V func, V args, Writer<?, ?> part, int step) {
        this.recon = recon;
        this.func = func;
        this.args = args;
        this.part = part;
        this.step = step;
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return InvokeOperatorWriter.write(output, this.recon, this.func, this.args, this.part, this.step);
    }

    static <I, V> int sizeOf(ReconWriter<I, V> recon, V func, V args) {
        int size = 0;
        size += recon.sizeOfValue(func);
        ++size;
        size += recon.sizeOfBlockValue(args);
        return ++size;
    }

    static <I, V> Writer<Object, Object> write(Output<?> output, ReconWriter<I, V> recon, V func, V args, Writer<?, ?> part, int step) {
        if (step == 1) {
            if ((part = part == null ? recon.writeValue(func, output) : part.pull(output)).isDone()) {
                part = null;
                step = 2;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 2 && output.isCont()) {
            output = output.write(40);
            step = 3;
        }
        if (step == 3) {
            if ((part = part == null ? recon.writeBlockValue(args, output) : part.pull(output)).isDone()) {
                part = null;
                step = 4;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 4 && output.isCont()) {
            output = output.write(41);
            return InvokeOperatorWriter.done();
        }
        if (output.isDone()) {
            return InvokeOperatorWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return InvokeOperatorWriter.error((Throwable)output.trap());
        }
        return new InvokeOperatorWriter<I, V>(recon, func, args, part, step);
    }

    static <I, V> Writer<Object, Object> write(Output<?> output, ReconWriter<I, V> recon, V func, V args) {
        return InvokeOperatorWriter.write(output, recon, func, args, null, 1);
    }
}

