/*
 * Decompiled with CFR 0.152.
 */
package swim.structure;

import swim.codec.Output;
import swim.codec.OutputSettings;
import swim.structure.Data;

final class DataOutput
extends Output<Data> {
    final Data data;
    OutputSettings settings;

    DataOutput(Data data, OutputSettings settings) {
        this.data = data;
        this.settings = settings;
    }

    public boolean isCont() {
        return true;
    }

    public boolean isFull() {
        return false;
    }

    public boolean isDone() {
        return false;
    }

    public boolean isError() {
        return false;
    }

    public boolean isPart() {
        return false;
    }

    public Output<Data> isPart(boolean isPart) {
        return this;
    }

    public Output<Data> write(int b) {
        this.data.addByte((byte)b);
        return this;
    }

    public Output<Data> write(String string) {
        throw new UnsupportedOperationException();
    }

    public Output<Data> writeln(String string) {
        throw new UnsupportedOperationException();
    }

    public Output<Data> writeln() {
        throw new UnsupportedOperationException();
    }

    public OutputSettings settings() {
        return this.settings;
    }

    public Output<Data> settings(OutputSettings settings) {
        this.settings = settings;
        return this;
    }

    public Data bind() {
        return this.data;
    }

    public Output<Data> clone() {
        return new DataOutput(this.data.branch(), this.settings);
    }
}

