/*
 * Decompiled with CFR 0.152.
 */
package swim.structure;

import java.util.Collection;
import swim.structure.Field;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;
import swim.util.Builder;

final class ValueBuilder
implements Builder<Item, Value> {
    Record record = null;
    Value value = null;

    ValueBuilder() {
    }

    public boolean add(Item item) {
        if (item instanceof Field) {
            return this.addField((Field)item);
        }
        if (item instanceof Value) {
            return this.addValue((Value)item);
        }
        throw new AssertionError(item);
    }

    public boolean addAll(Collection<? extends Item> items) {
        for (Item item : items) {
            this.add(item);
        }
        return true;
    }

    boolean addField(Field item) {
        if (this.record == null) {
            this.record = Record.create();
            if (this.value != null) {
                this.record.add(this.value);
                this.value = null;
            }
        }
        this.record.add(item);
        return true;
    }

    boolean addValue(Value item) {
        if (this.record != null) {
            this.record.add(item);
        } else if (this.value == null) {
            this.value = item;
        } else {
            this.record = Record.create();
            this.record.add(this.value);
            this.value = null;
            this.record.add(item);
        }
        return true;
    }

    public Value bind() {
        if (this.record != null) {
            return this.record;
        }
        if (this.value != null) {
            return this.value;
        }
        return Value.absent();
    }
}

