/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.form;

import java.lang.reflect.Constructor;
import java.util.Collection;
import swim.structure.Form;
import swim.structure.FormException;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

public final class CollectionForm<T>
extends Form<Collection<T>> {
    final Class<?> type;
    final Form<T> form;
    final Constructor<Collection<T>> constructor;

    public CollectionForm(Class<?> type, Form<T> form) {
        this.type = type;
        this.form = form;
        try {
            this.constructor = type.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException cause) {
            throw new FormException(cause);
        }
    }

    @Override
    public Collection<T> unit() {
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException cause) {
            throw new FormException(cause);
        }
    }

    @Override
    public Class<?> type() {
        return this.type;
    }

    @Override
    public Item mold(Collection<T> collection, Item item) {
        if (collection != null) {
            for (T elem : collection) {
                item = item.appended(this.form.mold(elem));
            }
            return item;
        }
        return Item.extant();
    }

    @Override
    public Item mold(Collection<T> collection) {
        if (collection != null) {
            Record record = Record.create();
            for (T elem : collection) {
                record.add(this.form.mold(elem));
            }
            return record;
        }
        return Item.extant();
    }

    @Override
    public Collection<T> cast(Item item, Collection<T> collection) {
        Value value = item.toValue();
        for (Item child : value) {
            T elem = this.form.cast(child);
            if (elem == null) continue;
            collection.add(elem);
        }
        return collection;
    }

    @Override
    public Collection<T> cast(Item item) {
        T elem;
        Value value = item.toValue();
        int n = value.length();
        if (n > 0) {
            Collection<T> collection;
            try {
                collection = this.constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException cause) {
                throw new FormException(cause);
            }
            for (Item child : value) {
                T elem2 = this.form.cast(child);
                if (elem2 == null) continue;
                collection.add(elem2);
            }
            return collection;
        }
        if (value.isDefined() && (elem = this.form.cast(value)) != null) {
            Collection<T> collection;
            try {
                collection = this.constructor.newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException cause) {
                throw new FormException(cause);
            }
            collection.add(elem);
            return collection;
        }
        return null;
    }
}

