/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.Base16;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Utf8;
import swim.uri.Uri;
import swim.uri.UriParser;
import swim.uri.UriUser;

final class UriUserParser
extends Parser<UriUser> {
    final UriParser uri;
    final Output<String> usernameOutput;
    final Output<String> passwordOutput;
    final int c1;
    final int step;

    UriUserParser(UriParser uri, Output<String> usernameOutput, Output<String> passwordOutput, int c1, int step) {
        this.uri = uri;
        this.usernameOutput = usernameOutput;
        this.passwordOutput = passwordOutput;
        this.c1 = c1;
        this.step = step;
    }

    UriUserParser(UriParser uri) {
        this(uri, null, null, 0, 1);
    }

    public Parser<UriUser> feed(Input input) {
        return UriUserParser.parse(input, this.uri, this.usernameOutput, this.passwordOutput, this.c1, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<UriUser> parse(Input input, UriParser uri, Output<String> usernameOutput, Output<String> passwordOutput, int c1, int step) {
        block27: {
            int c = 0;
            while (true) {
                if (step == 1) {
                    if (usernameOutput == null) {
                        usernameOutput = Utf8.decodedString();
                    }
                    while (input.isCont() && Uri.isUserChar(c = input.head())) {
                        input = input.step();
                        usernameOutput.write(c);
                    }
                    if (input.isCont() && c == 58) {
                        input = input.step();
                        step = 4;
                    } else if (input.isCont() && c == 37) {
                        input = input.step();
                        step = 2;
                    } else if (!input.isEmpty()) {
                        return UriUserParser.done((Object)uri.user((String)usernameOutput.bind(), null));
                    }
                }
                if (step == 2) {
                    if (input.isCont()) {
                        c = input.head();
                        if (!Base16.isDigit((int)c)) return UriUserParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                        input = input.step();
                        c1 = c;
                        step = 3;
                    } else if (input.isDone()) {
                        return UriUserParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                    }
                }
                if (step == 3) {
                    if (input.isCont()) {
                        c = input.head();
                        if (!Base16.isDigit((int)c)) return UriUserParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                        input = input.step();
                        usernameOutput.write(Base16.decodeDigit((int)c1) << 4 | Base16.decodeDigit((int)c));
                        c1 = 0;
                        step = 1;
                        continue;
                    }
                    if (input.isDone()) {
                        return UriUserParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                    }
                }
                if (step == 4) {
                    if (passwordOutput == null) {
                        passwordOutput = Utf8.decodedString();
                    }
                    while (input.isCont() && Uri.isUserInfoChar(c = input.head())) {
                        input = input.step();
                        passwordOutput.write(c);
                    }
                    if (input.isCont() && c == 37) {
                        input = input.step();
                        step = 5;
                    } else if (!input.isEmpty()) {
                        return UriUserParser.done((Object)uri.user((String)usernameOutput.bind(), (String)passwordOutput.bind()));
                    }
                }
                if (step == 5) {
                    if (input.isCont()) {
                        c = input.head();
                        if (!Base16.isDigit((int)c)) return UriUserParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                        input = input.step();
                        c1 = c;
                        step = 6;
                    } else if (input.isDone()) {
                        return UriUserParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                    }
                }
                if (step != 6) break block27;
                if (!input.isCont()) break;
                c = input.head();
                if (!Base16.isDigit((int)c)) return UriUserParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
                input = input.step();
                passwordOutput.write(Base16.decodeDigit((int)c1) << 4 | Base16.decodeDigit((int)c));
                c1 = 0;
                step = 4;
            }
            if (input.isDone()) {
                return UriUserParser.error((Diagnostic)Diagnostic.expected((String)"hex digit", (Input)input));
            }
        }
        if (!input.isError()) return new UriUserParser(uri, (Output<String>)usernameOutput, (Output<String>)passwordOutput, c1, step);
        return UriUserParser.error((Throwable)input.trap());
    }

    static Parser<UriUser> parse(Input input, UriParser uri) {
        return UriUserParser.parse(input, uri, null, null, 0, 1);
    }
}

