/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.deflate.DeflateException;
import swim.ws.WsDeflateDecoder;
import swim.ws.WsFrame;
import swim.ws.WsOpcode;

final class WsFrameInflater<O>
extends Decoder<WsFrame<O>> {
    final WsDeflateDecoder ws;
    final Decoder<O> content;
    final int finRsvOp;
    final long position;
    final long offset;
    final long length;
    final byte[] maskingKey;
    final int step;
    private static final byte[] EMPTY_BLOCK = new byte[]{0, 0, -1, -1};

    WsFrameInflater(WsDeflateDecoder ws, Decoder<O> content, int finRsvOp, long position, long offset, long length, byte[] maskingKey, int step) {
        this.ws = ws;
        this.content = content;
        this.finRsvOp = finRsvOp;
        this.position = position;
        this.offset = offset;
        this.length = length;
        this.maskingKey = maskingKey;
        this.step = step;
    }

    WsFrameInflater(WsDeflateDecoder ws, Decoder<O> content) {
        this(ws, content, 0, 0L, 0L, 0L, null, 1);
    }

    public Decoder<WsFrame<O>> feed(InputBuffer input) {
        return WsFrameInflater.decode(input, this.ws, this.content, this.finRsvOp, this.position, this.offset, this.length, this.maskingKey, this.step);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <O> Decoder<WsFrame<O>> decode(InputBuffer input, WsDeflateDecoder ws, Decoder<O> content, int finRsvOp, long position, long offset, long length, byte[] maskingKey, int step) {
        if (step == 1 && input.isCont()) {
            finRsvOp = input.head();
            input = input.step();
            step = 2;
        }
        if (step == 2 && input.isCont()) {
            int len;
            int maskLength = input.head();
            input = input.step();
            if ((maskLength & 0x80) != 0) {
                maskingKey = new byte[4];
            }
            if ((len = maskLength & 0x7F) == 126) {
                step = 3;
            } else if (len == 127) {
                step = 5;
            } else {
                length = len;
                int n = step = maskingKey != null ? 13 : 17;
            }
        }
        if (step >= 3 && step <= 4) {
            while (input.isCont()) {
                length = length << 8 | (long)input.head();
                input = input.step();
                if (step < 4) {
                    ++step;
                    continue;
                }
                int n = step = maskingKey != null ? 13 : 17;
                break;
            }
        }
        if (step >= 5 && step <= 12) {
            while (input.isCont()) {
                length = length << 8 | (long)input.head();
                input = input.step();
                if (step < 12) {
                    ++step;
                    continue;
                }
                int n = step = maskingKey != null ? 13 : 17;
                break;
            }
        }
        if (step >= 13 && step <= 16) {
            while (input.isCont()) {
                maskingKey[step - 13] = (byte)input.head();
                input = input.step();
                if (step < 16) {
                    ++step;
                    continue;
                }
                step = 17;
                break;
            }
        }
        if (step == 17) {
            int opcode;
            int base = input.index();
            int size = (int)Math.min(length - offset, (long)input.remaining());
            if (maskingKey != null) {
                for (int i = 0; i < size; ++i) {
                    input.set(base + i, (input.get(base + i) ^ maskingKey[(int)(position + (long)i) & 3]) & 0xFF);
                }
            }
            position += (long)size;
            boolean eof = (offset += (long)size) == length && (finRsvOp & 0x80) != 0;
            ws.inflate.initWindow();
            ws.inflate.next_out = ws.inflate.window;
            ws.inflate.output = content;
            ws.inflate.is_last = false;
            ws.inflate.next_in = input.array();
            ws.inflate.next_in_index = input.arrayOffset() + base;
            ws.inflate.avail_in = Math.min(input.remaining(), size);
            try {
                boolean needsMore;
                do {
                    ws.inflate.next_out_index = ws.inflate.wnext;
                    ws.inflate.avail_out = ws.inflate.window.length - ws.inflate.wnext;
                    needsMore = ws.inflate.inflate(2);
                    content = ws.inflate.output;
                } while (needsMore && ws.inflate.avail_in > 0 && content.isCont());
                input = input.index(ws.inflate.next_in_index - input.arrayOffset());
                if (eof) {
                    ws.inflate.next_in = EMPTY_BLOCK;
                    ws.inflate.next_in_index = 0;
                    ws.inflate.avail_in = 4;
                    do {
                        ws.inflate.next_out_index = ws.inflate.wnext;
                        ws.inflate.avail_out = ws.inflate.window.length - ws.inflate.wnext;
                        needsMore = ws.inflate.inflate(2);
                        content = ws.inflate.output;
                    } while (needsMore && ws.inflate.avail_in > 0 && content.isCont());
                    if (content.isCont()) {
                        ws.inflate.window_buffer.index(ws.inflate.next_out_index).limit(ws.inflate.next_out_index).isPart(false);
                        ws.inflate.output = content = content.feed(ws.inflate.window_buffer);
                    }
                }
            }
            catch (DeflateException cause) {
                Decoder decoder = WsFrameInflater.error((Throwable)cause);
                return decoder;
            }
            finally {
                ws.inflate.next_out = null;
                ws.inflate.next_out_index = 0;
                ws.inflate.avail_out = 0;
                ws.inflate.next_in = null;
                ws.inflate.next_in_index = 0;
                ws.inflate.avail_in = 0;
            }
            if (input.index() != base + size) {
                return WsFrameInflater.error((Throwable)new DecoderException("undecoded websocket data"));
            }
            if (content.isError()) {
                return content.asError();
            }
            if (content.isDone()) {
                if (offset == length) {
                    if ((finRsvOp & 0x80) != 0) {
                        opcode = finRsvOp & 0xF;
                        if (opcode < 8) {
                            return WsFrameInflater.done(ws.message(content.bind()));
                        }
                        return WsFrameInflater.done(ws.control(WsOpcode.from(opcode), content.bind()));
                    }
                    return WsFrameInflater.error((Throwable)new DecoderException("decoded unfinished websocket message"));
                }
                return WsFrameInflater.error((Throwable)new DecoderException("decoded incomplete websocket frame"));
            }
            if (offset == length) {
                if ((finRsvOp & 0x80) == 0) {
                    opcode = finRsvOp & 0xF;
                    if (opcode < 8) {
                        return WsFrameInflater.done(ws.fragment(WsOpcode.from(opcode), content));
                    }
                    return WsFrameInflater.error((Throwable)new DecoderException("decoded fragmented control frame"));
                }
                return WsFrameInflater.error((Throwable)new DecoderException("undecoded websocket message"));
            }
        }
        if (input.isDone()) {
            return WsFrameInflater.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return WsFrameInflater.error((Throwable)input.trap());
        }
        return new WsFrameInflater<O>(ws, content, finRsvOp, position, offset, length, maskingKey, step);
    }

    static <O> Decoder<WsFrame<O>> decode(InputBuffer input, WsDeflateDecoder ws, Decoder<O> content) {
        return WsFrameInflater.decode(input, ws, content, 0, 0L, 0L, 0L, null, 1);
    }
}

