/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.AbstractMap;
import java.util.Map;
import swim.collections.BTreeContext;
import swim.collections.BTreeLeafCursor;
import swim.collections.BTreeNode;
import swim.collections.BTreePage;
import swim.util.CombinerFunction;
import swim.util.OrderedMapCursor;

class BTreeLeaf<K, V, U>
extends BTreePage<K, V, U> {
    final Map.Entry<K, V>[] slots;
    final U fold;
    private static BTreeLeaf<Object, Object, Object> empty;

    BTreeLeaf(Map.Entry<K, V>[] slots, U fold) {
        this.slots = slots;
        this.fold = fold;
    }

    @Override
    public final boolean isEmpty() {
        return this.slots.length == 0;
    }

    @Override
    public final int size() {
        return this.slots.length;
    }

    @Override
    public final int arity() {
        return this.slots.length;
    }

    @Override
    public final U fold() {
        return this.fold;
    }

    @Override
    public final K minKey() {
        return this.slots[0].getKey();
    }

    @Override
    public final K maxKey() {
        return this.slots[this.slots.length - 1].getKey();
    }

    @Override
    public final boolean containsKey(Object key, BTreeContext<K, V> tree) {
        return this.lookup(key, tree) >= 0;
    }

    @Override
    public final boolean containsValue(Object value) {
        Map.Entry<K, V>[] slots = this.slots;
        int n = slots.length;
        for (int i = 0; i < n; ++i) {
            if (!value.equals(slots[i].getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public final int indexOf(Object key, BTreeContext<K, V> tree) {
        return this.lookup(key, tree);
    }

    @Override
    public final V get(Object key, BTreeContext<K, V> tree) {
        int x = this.lookup(key, tree);
        if (x >= 0) {
            return this.slots[x].getValue();
        }
        return null;
    }

    @Override
    public final Map.Entry<K, V> getEntry(Object key, BTreeContext<K, V> tree) {
        int x = this.lookup(key, tree);
        if (x >= 0) {
            return this.slots[x];
        }
        return null;
    }

    @Override
    public final Map.Entry<K, V> getIndex(int index) {
        return this.slots[index];
    }

    @Override
    public final Map.Entry<K, V> firstEntry() {
        if (this.slots.length != 0) {
            return this.slots[0];
        }
        return null;
    }

    @Override
    public final Map.Entry<K, V> lastEntry() {
        if (this.slots.length != 0) {
            return this.slots[this.slots.length - 1];
        }
        return null;
    }

    @Override
    public final Map.Entry<K, V> nextEntry(K key, BTreeContext<K, V> tree) {
        int x = this.lookup(key, tree);
        x = x >= 0 ? ++x : -(x + 1);
        if (0 <= x && x < this.slots.length) {
            return this.slots[x];
        }
        return null;
    }

    @Override
    public final Map.Entry<K, V> previousEntry(K key, BTreeContext<K, V> tree) {
        int x = this.lookup(key, tree);
        x = x >= 0 ? --x : -(x + 2);
        if (0 <= x && x < this.slots.length) {
            return this.slots[x];
        }
        return null;
    }

    @Override
    public final BTreeLeaf<K, V, U> updated(K key, V newValue, BTreeContext<K, V> tree) {
        int x = this.lookup(key, tree);
        if (x >= 0) {
            return this.updatedSlot(x, key, newValue);
        }
        x = -(x + 1);
        return this.insertedSlot(x, key, newValue);
    }

    private BTreeLeaf<K, V, U> updatedSlot(int x, K key, V newValue) {
        Map.Entry<K, V>[] oldSlots = this.slots;
        if (newValue != oldSlots[x].getValue()) {
            Map.Entry[] newSlots = new Map.Entry[oldSlots.length];
            System.arraycopy(oldSlots, 0, newSlots, 0, oldSlots.length);
            newSlots[x] = new AbstractMap.SimpleImmutableEntry<K, V>(key, newValue);
            return this.newLeaf(newSlots, null);
        }
        return this;
    }

    private BTreeLeaf<K, V, U> insertedSlot(int x, K key, V newValue) {
        Map.Entry<K, V>[] oldSlots = this.slots;
        int n = oldSlots.length + 1;
        Map.Entry[] newSlots = new Map.Entry[n];
        System.arraycopy(oldSlots, 0, newSlots, 0, x);
        newSlots[x] = new AbstractMap.SimpleImmutableEntry<K, V>(key, newValue);
        System.arraycopy(oldSlots, x, newSlots, x + 1, n - (x + 1));
        return this.newLeaf(newSlots, null);
    }

    @Override
    public final BTreeLeaf<K, V, U> removed(Object key, BTreeContext<K, V> tree) {
        int x = this.lookup(key, tree);
        if (x >= 0) {
            if (this.slots.length > 1) {
                return this.removedSlot(x);
            }
            return BTreeLeaf.empty();
        }
        return this;
    }

    private BTreeLeaf<K, V, U> removedSlot(int x) {
        Map.Entry<K, V>[] oldSlots = this.slots;
        int n = oldSlots.length - 1;
        Map.Entry[] newSlots = new Map.Entry[n];
        System.arraycopy(oldSlots, 0, newSlots, 0, x);
        System.arraycopy(oldSlots, x + 1, newSlots, x, n - x);
        return this.newLeaf(newSlots, null);
    }

    @Override
    public final BTreeLeaf<K, V, U> drop(int lower, BTreeContext<K, V> tree) {
        if (lower > 0) {
            Map.Entry<K, V>[] oldSlots = this.slots;
            int k = oldSlots.length;
            if (lower < k) {
                int n = k - lower;
                Map.Entry[] newSlots = new Map.Entry[n];
                System.arraycopy(oldSlots, lower, newSlots, 0, n);
                return this.newLeaf(newSlots, null);
            }
            return BTreeLeaf.empty();
        }
        return this;
    }

    @Override
    public final BTreeLeaf<K, V, U> take(int upper, BTreeContext<K, V> tree) {
        Map.Entry<K, V>[] oldSlots = this.slots;
        if (upper < oldSlots.length) {
            if (upper > 0) {
                Map.Entry[] newSlots = new Map.Entry[upper];
                System.arraycopy(oldSlots, 0, newSlots, 0, upper);
                return this.newLeaf(newSlots, null);
            }
            return BTreeLeaf.empty();
        }
        return this;
    }

    @Override
    public final BTreePage<K, V, U> balanced(BTreeContext<K, V> tree) {
        int n = this.slots.length;
        if (n > 1 && tree.pageShouldSplit(this)) {
            int x = n >>> 1;
            return this.split(x);
        }
        return this;
    }

    @Override
    public final BTreeNode<K, V, U> split(int x) {
        BTreePage[] newPages = new BTreePage[2];
        BTreePage newLeftPage = this.splitLeft(x);
        BTreePage newRightPage = this.splitRight(x);
        newPages[0] = newLeftPage;
        newPages[1] = newRightPage;
        Object[] newKnots = new Object[]{((BTreeLeaf)newRightPage).minKey()};
        return this.newNode(newPages, newKnots, null, this.slots.length);
    }

    @Override
    public final BTreeLeaf<K, V, U> splitLeft(int x) {
        Map.Entry<K, V>[] oldSlots = this.slots;
        Map.Entry[] newSlots = new Map.Entry[x];
        System.arraycopy(oldSlots, 0, newSlots, 0, x);
        return this.newLeaf(newSlots, null);
    }

    @Override
    public final BTreeLeaf<K, V, U> splitRight(int x) {
        Map.Entry<K, V>[] oldSlots = this.slots;
        int y = oldSlots.length - x;
        Map.Entry[] newSlots = new Map.Entry[y];
        System.arraycopy(oldSlots, x, newSlots, 0, y);
        return this.newLeaf(newSlots, null);
    }

    @Override
    public final BTreeLeaf<K, V, U> reduced(U identity, CombinerFunction<? super V, U> accumulator, CombinerFunction<U, U> combiner) {
        if (this.fold == null) {
            Map.Entry<K, V>[] slots = this.slots;
            Object fold = identity;
            int n = slots.length;
            for (int i = 0; i < n; ++i) {
                fold = accumulator.combine(fold, slots[i].getValue());
            }
            return this.newLeaf(slots, fold);
        }
        return this;
    }

    @Override
    public final OrderedMapCursor<K, V> iterator() {
        return new BTreeLeafCursor<K, V>(this.slots, 0, this.slots.length);
    }

    @Override
    public final OrderedMapCursor<K, V> lastIterator() {
        return new BTreeLeafCursor<K, V>(this.slots, this.slots.length, this.slots.length);
    }

    protected final int lookup(Object key, BTreeContext<K, V> tree) {
        int lo = 0;
        int hi = this.slots.length - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int order = tree.compareKey(key, this.slots[mid].getKey());
            if (order > 0) {
                lo = mid + 1;
                continue;
            }
            if (order < 0) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return -(lo + 1);
    }

    protected BTreeLeaf<K, V, U> newLeaf(Map.Entry<K, V>[] slots, U fold) {
        return new BTreeLeaf<K, V, U>(slots, fold);
    }

    protected BTreeNode<K, V, U> newNode(BTreePage<K, V, U>[] pages, K[] knots, U fold, int size) {
        return new BTreeNode<K, V, U>(pages, knots, fold, size);
    }

    public static <K, V, U> BTreeLeaf<K, V, U> empty() {
        if (empty == null) {
            empty = new BTreeLeaf<K, V, Object>(new Map.Entry[0], null);
        }
        return empty;
    }
}

