/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.math.Random;

public class MersenneTwister64
extends Random {
    final long[] state = new long[312];
    int index = 0;

    public MersenneTwister64(long seed) {
        this.state[0] = seed;
        for (int i = 1; i < 312; ++i) {
            this.state[i] = 6364136223846793005L * (this.state[i - 1] ^ this.state[i - 1] >>> 62) + (long)i;
        }
    }

    public MersenneTwister64(long[] key) {
        this(19650218L);
        int k;
        int i = 1;
        int j = 0;
        for (k = Math.max(312, key.length); k != 0; --k) {
            this.state[i] = (this.state[i] ^ (this.state[i - 1] ^ this.state[i - 1] >>> 62) * 3935559000370003845L) + key[j] + (long)j;
            ++j;
            if (++i > 311) {
                this.state[0] = this.state[311];
                i = 1;
            }
            if (j < key.length) continue;
            j = 0;
        }
        for (k = 311; k != 0; --k) {
            this.state[i] = (this.state[i] ^ (this.state[i - 1] ^ this.state[i - 1] >>> 62) * 2862933555777941757L) - (long)i;
            if (++i <= 311) continue;
            this.state[0] = this.state[311];
            i = 1;
        }
        this.state[0] = Long.MIN_VALUE;
    }

    public MersenneTwister64() {
        this(System.currentTimeMillis());
    }

    void generate() {
        int i;
        long[] state = this.state;
        long x = 0L;
        for (i = 0; i < 156; ++i) {
            x = state[i] & Integer.MIN_VALUE | state[i + 1] & Integer.MAX_VALUE;
            state[i] = state[i + 156] ^ x >>> 1 ^ ((x & 1L) == 0L ? 0L : -5403634167711393303L);
        }
        while (i < 311) {
            x = state[i] & Integer.MIN_VALUE | state[i + 1] & Integer.MAX_VALUE;
            state[i] = state[i - 156] ^ x >>> 1 ^ ((x & 1L) == 0L ? 0L : -5403634167711393303L);
            ++i;
        }
        x = state[311] & Integer.MIN_VALUE | state[0] & Integer.MAX_VALUE;
        state[311] = state[155] ^ x >>> 1 ^ ((x & 1L) == 0L ? 0L : -5403634167711393303L);
    }

    long next() {
        if (this.index >= 312) {
            this.generate();
            this.index = 0;
        }
        long x = this.state[this.index];
        x ^= x >>> 29 & 0x5555555555555555L;
        x ^= x << 17 & 0x71D67FFFEDA60000L;
        x ^= x << 37 & 0xFFF7EEE000000000L;
        x ^= x >>> 43;
        ++this.index;
        return x;
    }

    @Override
    public byte nextByte() {
        return (byte)this.next();
    }

    @Override
    public short nextShort() {
        return (short)this.next();
    }

    @Override
    public int nextInt() {
        return (int)this.next();
    }

    @Override
    public long nextLong() {
        return this.next();
    }

    @Override
    public float nextFloat() {
        return (float)(this.nextInt() >>> 8) / 1.6777216E7f;
    }

    @Override
    public double nextDouble() {
        return (double)(this.nextLong() >>> 11) / 9.007199254740992E15;
    }

    @Override
    public boolean nextBoolean() {
        return this.next() >>> 63 != 0L;
    }
}

