/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Output;
import swim.codec.Unicode;
import swim.codec.Utf8;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.recon.ReconWriter;

final class InfixOperatorWriter<I, V>
extends Writer<Object, Object> {
    final ReconWriter<I, V> recon;
    final I lhs;
    final String operator;
    final I rhs;
    final int precedence;
    final Writer<?, ?> part;
    final int step;

    InfixOperatorWriter(ReconWriter<I, V> recon, I lhs, String operator, I rhs, int precedence, Writer<?, ?> part, int step) {
        this.recon = recon;
        this.lhs = lhs;
        this.operator = operator;
        this.rhs = rhs;
        this.precedence = precedence;
        this.part = part;
        this.step = step;
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return InfixOperatorWriter.write(output, this.recon, this.lhs, this.operator, this.rhs, this.precedence, this.part, this.step);
    }

    static <I, V> int sizeOf(ReconWriter<I, V> recon, I lhs, String operator, I rhs, int precedence) {
        int size = 0;
        if (recon.precedence(lhs) < precedence) {
            ++size;
            size += recon.sizeOfItem(lhs);
            ++size;
        } else {
            size += recon.sizeOfItem(lhs);
        }
        ++size;
        size += Utf8.sizeOf((String)operator);
        ++size;
        if (recon.precedence(rhs) < precedence) {
            ++size;
            size += recon.sizeOfItem(rhs);
            ++size;
        } else {
            size += recon.sizeOfItem(rhs);
        }
        return size;
    }

    static <I, V> Writer<Object, Object> write(Output<?> output, ReconWriter<I, V> recon, I lhs, String operator, I rhs, int precedence, Writer<?, ?> part, int step) {
        if (step == 1) {
            if (recon.precedence(lhs) < precedence) {
                if (output.isCont()) {
                    output = output.write(40);
                    step = 2;
                }
            } else {
                step = 2;
            }
        }
        if (step == 2) {
            if ((part = part == null ? recon.writeItem(lhs, output) : part.pull(output)).isDone()) {
                part = null;
                step = 3;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 3) {
            if (recon.precedence(lhs) < precedence) {
                if (output.isCont()) {
                    output = output.write(41);
                    step = 4;
                }
            } else {
                step = 4;
            }
        }
        if (step == 4 && output.isCont()) {
            output = output.write(32);
            step = 5;
        }
        if (step == 5) {
            if ((part = part == null ? Unicode.writeString((Object)operator, (Output)output) : part.pull(output)).isDone()) {
                part = null;
                step = 6;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 6 && output.isCont()) {
            output = output.write(32);
            step = 7;
        }
        if (step == 7) {
            if (recon.precedence(rhs) < precedence) {
                if (output.isCont()) {
                    output = output.write(40);
                    step = 8;
                }
            } else {
                step = 8;
            }
        }
        if (step == 8) {
            if ((part = part == null ? recon.writeItem(rhs, output) : part.pull(output)).isDone()) {
                part = null;
                step = 9;
            } else if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 9) {
            if (recon.precedence(rhs) < precedence) {
                if (output.isCont()) {
                    output = output.write(41);
                    return InfixOperatorWriter.done();
                }
            } else {
                return InfixOperatorWriter.done();
            }
        }
        if (output.isDone()) {
            return InfixOperatorWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return InfixOperatorWriter.error((Throwable)output.trap());
        }
        return new InfixOperatorWriter<I, V>(recon, lhs, operator, rhs, precedence, (Writer<?, ?>)part, step);
    }

    static <I, V> Writer<Object, Object> write(Output<?> output, ReconWriter<I, V> recon, I lhs, String operator, I rhs, int precedence) {
        return InfixOperatorWriter.write(output, recon, lhs, operator, rhs, precedence, null, 1);
    }
}

