/*
 * Decompiled with CFR 0.152.
 */
package swim.recon;

import swim.codec.Base16;
import swim.codec.Output;
import swim.codec.Utf8;
import swim.codec.Writer;
import swim.codec.WriterException;

final class MarkupTextWriter
extends Writer<Object, Object> {
    final String text;
    final int index;
    final int escape;
    final int step;

    MarkupTextWriter(String text, int index, int escape, int step) {
        this.text = text;
        this.index = index;
        this.escape = escape;
        this.step = step;
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return MarkupTextWriter.write(output, this.text, this.index, this.escape, this.step);
    }

    static int sizeOf(String text) {
        int size = 0;
        int i = 0;
        int n = text.length();
        while (i < n) {
            int c = text.codePointAt(i);
            size = c == 36 || c == 64 || c == 91 || c == 92 || c == 93 || c == 123 || c == 125 || c == 8 || c == 12 || c == 10 || c == 13 || c == 9 ? (size += 2) : (c < 32 ? (size += 6) : (size += Utf8.sizeOf((int)c)));
            i = text.offsetByCodePoints(i, 1);
        }
        return size;
    }

    static Writer<Object, Object> write(Output<?> output, String text, int index, int escape, int step) {
        int length = text.length();
        while (output.isCont()) {
            if (step == 1) {
                if (index < length) {
                    int c = text.codePointAt(index);
                    index = text.offsetByCodePoints(index, 1);
                    if (c == 36 || c == 64 || c == 91 || c == 92 || c == 93 || c == 123 || c == 125) {
                        output = output.write(92);
                        escape = c;
                        step = 2;
                        continue;
                    }
                    if (c == 8) {
                        output = output.write(92);
                        escape = 98;
                        step = 2;
                        continue;
                    }
                    if (c == 12) {
                        output = output.write(92);
                        escape = 102;
                        step = 2;
                        continue;
                    }
                    if (c == 10) {
                        output = output.write(92);
                        escape = 110;
                        step = 2;
                        continue;
                    }
                    if (c == 13) {
                        output = output.write(92);
                        escape = 114;
                        step = 2;
                        continue;
                    }
                    if (c == 9) {
                        output = output.write(92);
                        escape = 116;
                        step = 2;
                        continue;
                    }
                    if (c < 32) {
                        output = output.write(92);
                        escape = c;
                        step = 3;
                        continue;
                    }
                    output = output.write(c);
                    continue;
                }
                return MarkupTextWriter.done();
            }
            if (step == 2) {
                output = output.write(escape);
                escape = 0;
                step = 1;
                continue;
            }
            if (step == 3) {
                output = output.write(117);
                step = 4;
                continue;
            }
            if (step == 4) {
                output = output.write((int)Base16.uppercase().encodeDigit(escape >>> 12 & 0xF));
                step = 5;
                continue;
            }
            if (step == 5) {
                output = output.write((int)Base16.uppercase().encodeDigit(escape >>> 8 & 0xF));
                step = 6;
                continue;
            }
            if (step == 6) {
                output = output.write((int)Base16.uppercase().encodeDigit(escape >>> 4 & 0xF));
                step = 7;
                continue;
            }
            if (step != 7) continue;
            output = output.write((int)Base16.uppercase().encodeDigit(escape & 0xF));
            escape = 0;
            step = 1;
        }
        if (output.isDone()) {
            return MarkupTextWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return MarkupTextWriter.error((Throwable)output.trap());
        }
        return new MarkupTextWriter(text, index, escape, step);
    }

    static Writer<Object, Object> write(Output<?> output, String text) {
        return MarkupTextWriter.write(output, text, 0, 0, 1);
    }
}

