/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import swim.runtime.downlink.DownlinkModel;
import swim.runtime.downlink.DownlinkRelay;
import swim.runtime.downlink.DownlinkView;
import swim.warp.EventMessage;

final class DownlinkRelayOnEvent<View extends DownlinkView>
extends DownlinkRelay<DownlinkModel<View>, View> {
    final EventMessage message;

    DownlinkRelayOnEvent(DownlinkModel<View> model, EventMessage message) {
        super(model, 2);
        this.message = message;
    }

    @Override
    boolean runPhase(View view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                ((DownlinkView)view).downlinkWillReceive(this.message);
            }
            return ((DownlinkView)view).dispatchWillReceive(this.message.body(), preemptive);
        }
        if (phase == 1) {
            if (preemptive) {
                ((DownlinkView)view).downlinkDidReceive(this.message);
            }
            return ((DownlinkView)view).dispatchDidReceive(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    void done() {
        this.model.cueDown();
    }
}

