/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.downlink;

import java.util.Map;
import swim.runtime.downlink.DownlinkRelay;
import swim.runtime.downlink.ValueDownlinkModel;
import swim.runtime.downlink.ValueDownlinkView;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.warp.EventMessage;

final class ValueDownlinkRelaySet
extends DownlinkRelay<ValueDownlinkModel, ValueDownlinkView<?>> {
    final EventMessage message;
    Form<Object> valueForm;
    Value oldValue;
    Value newValue;
    Object oldObject;
    Object newObject;

    ValueDownlinkRelaySet(ValueDownlinkModel model, EventMessage message, Value newValue) {
        super(model, 4);
        this.message = message;
        this.newValue = newValue;
    }

    ValueDownlinkRelaySet(ValueDownlinkModel model, Value newValue) {
        super(model, 1, 3);
        this.message = null;
        this.newValue = newValue;
    }

    @Override
    void beginPhase(int phase) {
        if (phase == 1) {
            this.newValue = ((ValueDownlinkModel)this.model).willSet(this.newValue);
        } else if (phase == 2) {
            if (((ValueDownlinkModel)this.model).isStateful()) {
                do {
                    this.oldValue = ((ValueDownlinkModel)this.model).state;
                } while (this.oldValue != this.newValue && !ValueDownlinkModel.STATE.compareAndSet((ValueDownlinkModel)this.model, this.oldValue, this.newValue));
            }
            ((ValueDownlinkModel)this.model).didSet(this.newValue, this.oldValue);
        }
    }

    @Override
    boolean runPhase(ValueDownlinkView<?> view, int phase, boolean preemptive) {
        if (phase == 0) {
            if (preemptive) {
                view.downlinkWillReceive(this.message);
            }
            return view.dispatchWillReceive(this.message.body(), preemptive);
        }
        if (phase == 1) {
            this.newValue = view.downlinkWillSetValue(this.newValue);
            Form<?> valueForm = view.valueForm();
            if (this.valueForm != valueForm && valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.newValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
                this.newObject = valueForm.cast((Item)this.newValue);
            }
            if (preemptive) {
                this.newObject = view.downlinkWillSet(this.newObject);
            }
            Map.Entry<Boolean, Object> result = view.dispatchWillSet(this.oldObject, preemptive);
            this.newObject = result.getValue();
            if (this.oldObject != result.getValue()) {
                this.oldObject = this.newObject;
                this.newObject = result.getValue();
                this.newValue = valueForm.mold(this.newObject).toValue();
            }
            return result.getKey();
        }
        if (phase == 2) {
            view.downlinkDidSetValue(this.newValue, this.oldValue);
            Form<?> valueForm = view.valueForm();
            if (valueForm != null) {
                this.valueForm = valueForm;
                this.oldObject = valueForm.cast((Item)this.oldValue);
                if (this.oldObject == null) {
                    this.oldObject = valueForm.unit();
                }
                this.newObject = valueForm.cast((Item)this.newValue);
                if (this.newObject == null) {
                    this.newObject = valueForm.unit();
                }
            }
            if (preemptive) {
                view.downlinkDidSet(this.newObject, this.oldObject);
            }
            return view.dispatchDidSet(this.newObject, this.oldObject, preemptive);
        }
        if (phase == 3) {
            if (preemptive) {
                view.downlinkDidReceive(this.message);
            }
            return view.dispatchDidReceive(this.message.body(), preemptive);
        }
        throw new AssertionError();
    }

    @Override
    void done() {
        if (this.message != null) {
            ((ValueDownlinkModel)this.model).cueDown();
        } else {
            ((ValueDownlinkModel)this.model).cueUp();
        }
    }
}

