/*
 * Decompiled with CFR 0.152.
 */
package swim.runtime.lane;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.api.agent.AgentContext;
import swim.api.auth.Identity;
import swim.api.downlink.Downlink;
import swim.api.lane.Lane;
import swim.api.policy.Policy;
import swim.api.uplink.Uplink;
import swim.codec.Decoder;
import swim.collections.FingerTrieSeq;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.http.HttpRequest;
import swim.http.HttpResponse;
import swim.runtime.AbstractTierBinding;
import swim.runtime.HttpBinding;
import swim.runtime.LaneBinding;
import swim.runtime.LaneContext;
import swim.runtime.LinkBinding;
import swim.runtime.LinkContext;
import swim.runtime.PushRequest;
import swim.runtime.TierContext;
import swim.runtime.lane.HttpLaneUplink;
import swim.runtime.lane.LaneRelayDidEnter;
import swim.runtime.lane.LaneRelayDidLeave;
import swim.runtime.lane.LaneRelayDidRequestHttp;
import swim.runtime.lane.LaneRelayDidRespondHttp;
import swim.runtime.lane.LaneRelayDidUplink;
import swim.runtime.lane.LaneRelayDoRespondHttp;
import swim.runtime.lane.LaneRelayOnCommand;
import swim.runtime.lane.LaneRelayWillRequestHttp;
import swim.runtime.lane.LaneRelayWillRespondHttp;
import swim.runtime.lane.LaneView;
import swim.runtime.uplink.UplinkModem;
import swim.store.StoreBinding;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.CommandMessage;
import swim.warp.Envelope;

public abstract class LaneModel<View extends LaneView, U extends UplinkModem>
extends AbstractTierBinding
implements LaneBinding {
    protected LaneContext laneContext;
    volatile Object views;
    volatile FingerTrieSeq<U> uplinks = FingerTrieSeq.empty();
    static final AtomicReferenceFieldUpdater<LaneModel<? extends LaneView, ? extends UplinkModem>, Object> VIEWS = AtomicReferenceFieldUpdater.newUpdater(LaneModel.class, Object.class, "views");
    static final AtomicReferenceFieldUpdater<LaneModel<? extends LaneView, ? extends UplinkModem>, FingerTrieSeq<? extends UplinkModem>> UPLINKS = AtomicReferenceFieldUpdater.newUpdater(LaneModel.class, FingerTrieSeq.class, "uplinks");

    @Override
    public TierContext tierContext() {
        return this.laneContext;
    }

    @Override
    public LaneContext laneContext() {
        return this.laneContext;
    }

    @Override
    public void setLaneContext(LaneContext laneContext) {
        this.laneContext = laneContext;
    }

    @Override
    public <T> T unwrapLane(Class<T> laneClass) {
        if (laneClass.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        Object views = this.views;
        if (views instanceof LaneView) {
            return ((LaneView)views).unwrapLane(laneClass);
        }
        if (views instanceof LaneView[]) {
            LaneView[] viewArray = (LaneView[])views;
            int n = viewArray.length;
            for (int i = 0; i < n; ++i) {
                T lane = viewArray[i].unwrapLane(laneClass);
                if (lane == null) continue;
                return lane;
            }
        }
        return null;
    }

    protected abstract U createUplink(LinkBinding var1);

    @Override
    public final Uri meshUri() {
        return this.laneContext.meshUri();
    }

    @Override
    public final Value partKey() {
        return this.laneContext.partKey();
    }

    @Override
    public final Uri hostUri() {
        return this.laneContext.hostUri();
    }

    @Override
    public final Uri nodeUri() {
        return this.laneContext.nodeUri();
    }

    @Override
    public final Uri laneUri() {
        return this.laneContext.laneUri();
    }

    @Override
    public final Value agentKey() {
        return this.laneContext.agentKey();
    }

    @Override
    public Policy policy() {
        return this.laneContext.policy();
    }

    @Override
    public Schedule schedule() {
        return this.laneContext.schedule();
    }

    @Override
    public Stage stage() {
        return this.laneContext.stage();
    }

    @Override
    public StoreBinding store() {
        return this.laneContext.store();
    }

    @Override
    public Lane getLaneView(AgentContext agentContext) {
        Object views = this.views;
        if (views instanceof LaneView) {
            LaneView view = (LaneView)views;
            if (agentContext == view.agentContext()) {
                return view;
            }
        } else if (views instanceof LaneView[]) {
            for (LaneView view : (LaneView[])views) {
                if (agentContext != view.agentContext()) continue;
                return view;
            }
        }
        return null;
    }

    @Override
    public void openLaneView(Lane view) {
        LaneView[] newLaneViews;
        Object oldLaneViews;
        do {
            if ((oldLaneViews = this.views) instanceof LaneView) {
                newLaneViews = new LaneView[]{(LaneView)oldLaneViews, (LaneView)view};
                continue;
            }
            if (oldLaneViews instanceof LaneView[]) {
                LaneView[] oldLaneViewArray = (LaneView[])oldLaneViews;
                int n = oldLaneViewArray.length;
                LaneView[] newLaneViewArray = new LaneView[n + 1];
                System.arraycopy(oldLaneViewArray, 0, newLaneViewArray, 0, n);
                newLaneViewArray[n] = (LaneView)view;
                newLaneViews = newLaneViewArray;
                continue;
            }
            newLaneViews = (LaneView[])view;
        } while (!VIEWS.compareAndSet(this, oldLaneViews, newLaneViews));
        this.didOpenLaneView((LaneView)view);
    }

    @Override
    public void closeLaneView(Lane view) {
        LaneView[] newLaneViews;
        LaneView[] oldLaneViews;
        do {
            if ((oldLaneViews = this.views) instanceof LaneView) {
                if (oldLaneViews == view) {
                    newLaneViews = null;
                    continue;
                }
            } else if (oldLaneViews instanceof LaneView[]) {
                LaneView[] oldLaneViewArray = oldLaneViews;
                int n = oldLaneViewArray.length;
                if (n == 2) {
                    if (oldLaneViewArray[0] == view) {
                        newLaneViews = oldLaneViewArray[1];
                        continue;
                    }
                    if (oldLaneViewArray[1] == view) {
                        newLaneViews = oldLaneViewArray[0];
                        continue;
                    }
                } else {
                    int i;
                    LaneView[] newLaneViewArray = new LaneView[n - 1];
                    for (i = 0; i < n && oldLaneViewArray[i] != view; ++i) {
                        if (i >= n - 1) continue;
                        newLaneViewArray[i] = oldLaneViewArray[i];
                    }
                    if (i < n) {
                        System.arraycopy(oldLaneViewArray, i + 1, newLaneViewArray, i, n - (i + 1));
                        newLaneViews = newLaneViewArray;
                        continue;
                    }
                }
            }
            newLaneViews = oldLaneViews;
            break;
        } while (!VIEWS.compareAndSet(this, oldLaneViews, newLaneViews));
        if (oldLaneViews != newLaneViews) {
            this.didCloseLaneView((LaneView)view);
        }
        if (newLaneViews == null) {
            this.close();
        }
    }

    @Override
    public FingerTrieSeq<LinkContext> getUplinks() {
        return this.uplinks;
    }

    @Override
    public LinkBinding getUplink(Value linkKey) {
        FingerTrieSeq<U> uplinks = this.uplinks;
        int n = uplinks.size();
        for (int i = 0; i < n; ++i) {
            UplinkModem uplink = (UplinkModem)uplinks.get(i);
            if (!linkKey.equals((Object)uplink.linkKey())) continue;
            return uplink.linkBinding();
        }
        return null;
    }

    @Override
    public void openUplink(LinkBinding link) {
        FingerTrieSeq newUplinks;
        FingerTrieSeq<U> oldUplinks;
        U uplink = this.createUplink(link);
        link.setLinkContext((LinkContext)uplink);
        while (!UPLINKS.compareAndSet(this, oldUplinks = this.uplinks, (FingerTrieSeq<? extends UplinkModem>)(newUplinks = oldUplinks.appended(uplink)))) {
        }
        this.didUplink(uplink);
    }

    @Override
    public void closeUplink(Value linkKey) {
        UplinkModem linkContext;
        FingerTrieSeq newUplinks;
        FingerTrieSeq oldUplinks;
        block0: do {
            newUplinks = oldUplinks = this.uplinks;
            linkContext = null;
            int n = oldUplinks.size();
            for (int i = 0; i < n; ++i) {
                UplinkModem uplink = (UplinkModem)oldUplinks.get(i);
                if (!linkKey.equals((Object)uplink.linkKey())) continue;
                linkContext = uplink;
                newUplinks = oldUplinks.removed(i);
                continue block0;
            }
        } while (!UPLINKS.compareAndSet(this, oldUplinks, newUplinks));
        if (linkContext != null) {
            linkContext.linkBinding().didCloseUp();
        }
    }

    @Override
    public void httpUplink(HttpBinding http) {
        HttpLaneUplink httpContext = new HttpLaneUplink(this, http);
        http.setHttpContext(httpContext);
    }

    protected void cueDown() {
        FingerTrieSeq<U> uplinks;
        FingerTrieSeq closedLinks = FingerTrieSeq.empty();
        do {
            uplinks = this.uplinks;
            int n = uplinks.size();
            for (int i = 0; i < n; ++i) {
                UplinkModem u = (UplinkModem)uplinks.get(i);
                if (u.isConnected()) {
                    u.cueDown();
                    continue;
                }
                closedLinks = closedLinks.appended((Object)u.linkKey());
            }
        } while (uplinks != this.uplinks);
        for (Value linkKey : closedLinks) {
            this.closeUplink(linkKey);
        }
    }

    protected void sendDown(Value body) {
        FingerTrieSeq<U> uplinks;
        FingerTrieSeq closedLinks = FingerTrieSeq.empty();
        do {
            uplinks = this.uplinks;
            int n = uplinks.size();
            for (int i = 0; i < n; ++i) {
                UplinkModem u = (UplinkModem)uplinks.get(i);
                if (u.isConnected()) {
                    u.sendDown(body);
                    continue;
                }
                closedLinks = closedLinks.appended((Object)u.linkKey());
            }
        } while (uplinks != this.uplinks);
        for (Value linkKey : closedLinks) {
            this.closeUplink(linkKey);
        }
    }

    @Override
    public void pushUp(PushRequest pushRequest) {
        Envelope envelope = pushRequest.envelope();
        if (envelope instanceof CommandMessage) {
            this.onCommand((CommandMessage)envelope);
            pushRequest.didDeliver();
        } else {
            pushRequest.didDecline();
        }
    }

    @Override
    public void pushUpCommand(CommandMessage message) {
        this.onCommand(message);
    }

    protected void onCommand(CommandMessage message) {
        new LaneRelayOnCommand(this, message).run();
    }

    protected abstract void didOpenLaneView(View var1);

    protected void didCloseLaneView(View view) {
    }

    protected void didUplink(U uplink) {
        new LaneRelayDidUplink(this, (Uplink)uplink).run();
    }

    protected void didEnter(Identity identity) {
        new LaneRelayDidEnter(this, identity).run();
    }

    protected void didLeave(Identity identity) {
        new LaneRelayDidLeave(this, identity).run();
    }

    public Decoder<Object> decodeRequest(HttpLaneUplink uplink, HttpRequest<?> request) {
        Object views = this.views;
        Decoder<Object> decoder = null;
        if (views instanceof LaneView) {
            LaneView view = (LaneView)views;
            decoder = view.dispatchDecodeRequest(uplink, request);
            if (decoder == null) {
                decoder = view.laneDecodeRequest(uplink, request);
            }
        } else if (views instanceof LaneView[]) {
            for (LaneView view : (LaneView[])views) {
                decoder = view.dispatchDecodeRequest(uplink, request);
                if (decoder == null) {
                    decoder = view.laneDecodeRequest(uplink, request);
                }
                if (decoder != null) break;
            }
        }
        return decoder;
    }

    public void willRequest(HttpLaneUplink uplink, HttpRequest<?> request) {
        new LaneRelayWillRequestHttp(this, uplink, request).run();
    }

    public void didRequest(HttpLaneUplink uplink, HttpRequest<Object> request) {
        new LaneRelayDidRequestHttp(this, uplink, request).run();
    }

    public void doRespond(HttpLaneUplink uplink, HttpRequest<Object> request) {
        new LaneRelayDoRespondHttp(this, uplink, request).run();
    }

    public void willRespond(HttpLaneUplink uplink, HttpResponse<?> response) {
        new LaneRelayWillRespondHttp(this, uplink, response).run();
    }

    public void didRespond(HttpLaneUplink uplink, HttpResponse<?> response) {
        new LaneRelayDidRespondHttp(this, uplink, response).run();
    }

    @Override
    public LinkBinding bindDownlink(Downlink downlink) {
        return this.laneContext.bindDownlink(downlink);
    }

    @Override
    public void openDownlink(LinkBinding link) {
        this.laneContext.openDownlink(link);
    }

    @Override
    public void closeDownlink(LinkBinding link) {
        this.laneContext.closeDownlink(link);
    }

    @Override
    public void httpDownlink(HttpBinding http) {
        this.laneContext.httpDownlink(http);
    }

    @Override
    public void pushDown(PushRequest pushRequest) {
        this.laneContext.pushDown(pushRequest);
    }

    public void trace(Object message) {
        this.laneContext.trace(message);
    }

    public void debug(Object message) {
        this.laneContext.debug(message);
    }

    public void info(Object message) {
        this.laneContext.info(message);
    }

    public void warn(Object message) {
        this.laneContext.warn(message);
    }

    public void error(Object message) {
        this.laneContext.error(message);
    }

    @Override
    protected void willOpen() {
        super.willOpen();
    }

    @Override
    protected void willLoad() {
        super.willLoad();
    }

    @Override
    protected void willStart() {
        super.willStart();
    }

    @Override
    protected void willStop() {
        super.willStop();
    }

    @Override
    protected void willUnload() {
        super.willUnload();
    }

    @Override
    protected void willClose() {
        super.willClose();
        FingerTrieSeq<U> uplinks = this.uplinks;
        int n = uplinks.size();
        for (int i = 0; i < n; ++i) {
            ((UplinkModem)uplinks.get(i)).close();
        }
        this.laneContext.close();
    }

    @Override
    public void didClose() {
    }

    @Override
    public void didFail(Throwable error) {
        error.printStackTrace();
    }
}

