/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.util.Murmur3;
import swim.ws.WsControl;
import swim.ws.WsEncoder;
import swim.ws.WsOpcode;
import swim.ws.WsStatus;

public final class WsClose<P, T>
extends WsControl<P, T>
implements Debug {
    final P payload;
    final Encoder<?, ?> content;
    private static int hashSeed;

    WsClose(P payload, Encoder<?, ?> content) {
        this.payload = payload;
        this.content = content;
    }

    @Override
    public WsOpcode opcode() {
        return WsOpcode.CLOSE;
    }

    @Override
    public P payload() {
        return this.payload;
    }

    @Override
    public Encoder<?, ?> contentEncoder(WsEncoder ws) {
        return this.content;
    }

    @Override
    public Encoder<?, ?> encodeContent(OutputBuffer<?> output, WsEncoder ws) {
        return this.content.pull(output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof WsClose) {
            WsClose that = (WsClose)other;
            return this.payload == null ? that.payload == null : this.payload.equals(that.payload);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(WsClose.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash(this.payload)));
    }

    public void debug(Output<?> output) {
        output = output.write("WsClose").write(46).write("from").write(40).debug(this.payload).write(", ").debug(this.content).write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <P, T> WsClose<P, T> empty() {
        return new WsClose<Object, T>(null, Encoder.done());
    }

    public static <P, T> WsClose<P, T> from(P payload, Encoder<?, ?> content) {
        return new WsClose<P, T>(payload, content);
    }

    public static <P, T> WsClose<P, T> from(P payload) {
        if (payload instanceof WsStatus) {
            return WsClose.from((WsStatus)payload);
        }
        return new WsClose<P, T>(payload, Encoder.done());
    }

    public static <T> WsClose<WsStatus, T> from(WsStatus status) {
        return new WsClose<WsStatus, T>(status, status.encoder());
    }

    public static <T> WsClose<WsStatus, T> from(int code, String reason) {
        return WsClose.from(WsStatus.from(code, reason));
    }

    public static <T> WsClose<WsStatus, T> from(int code) {
        return WsClose.from(WsStatus.from(code));
    }
}

