/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import swim.math.DimensionException;
import swim.math.TensorDims;
import swim.math.TensorForm;
import swim.math.VectorRN;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

final class VectorRNForm
extends TensorForm<VectorRN> {
    VectorRNForm() {
    }

    public String tag() {
        return "vector";
    }

    public Class<?> type() {
        return VectorRN.class;
    }

    public Item mold(VectorRN vector) {
        if (vector != null) {
            double[] us = vector.array;
            int n = us.length;
            Record header = Record.create((int)n);
            for (int i = 0; i < n; ++i) {
                header.item(us[i]);
            }
            return Record.create((int)1).attr(this.tag(), (Value)header);
        }
        return Item.extant();
    }

    public VectorRN cast(Item item) {
        Value header = item.toValue().header(this.tag());
        if (header.isDefined()) {
            int n = header.length();
            double[] us = new double[n];
            for (int i = 0; i < n; ++i) {
                us[i] = header.getItem(i).doubleValue(0.0);
            }
            return new VectorRN(us);
        }
        return null;
    }

    @Override
    public VectorRN fromTensor(TensorDims dim, float[] tensor, int offset) {
        int n = dim.size;
        double[] us = new double[n];
        for (int i = 0; i < n; ++i) {
            us[i] = tensor[offset];
            offset += dim.stride;
        }
        return new VectorRN(us);
    }

    @Override
    public VectorRN fromTensor(TensorDims dim, double[] tensor, int offset) {
        int n = dim.size;
        double[] us = new double[n];
        if (dim.stride == 1) {
            System.arraycopy(tensor, offset, us, 0, n);
        } else {
            for (int i = 0; i < n; ++i) {
                us[i] = tensor[offset];
                offset += dim.stride;
            }
        }
        return new VectorRN(us);
    }

    @Override
    public void toTensor(VectorRN vector, TensorDims dim, float[] tensor, int offset) {
        double[] us = vector.array;
        int n = us.length;
        if (n != dim.size || dim.next != null) {
            throw new DimensionException();
        }
        for (int i = 0; i < n; ++i) {
            tensor[offset] = (float)us[i];
            offset += dim.stride;
        }
    }

    @Override
    public void toTensor(VectorRN vector, TensorDims dim, double[] tensor, int offset) {
        double[] us = vector.array;
        int n = us.length;
        if (n != dim.size || dim.next != null) {
            throw new DimensionException();
        }
        for (int i = 0; i < n; ++i) {
            tensor[offset] = us[i];
            offset += dim.stride;
        }
    }

    @Override
    public Item moldTensor(TensorDims dim, float[] tensor, int offset) {
        int n = dim.size;
        Record header = Record.create((int)n);
        for (int i = 0; i < n; ++i) {
            header.item(tensor[offset]);
            offset += dim.stride;
        }
        return Record.create((int)1).attr(this.tag(), (Value)header);
    }

    @Override
    public Item moldTensor(TensorDims dim, double[] tensor, int offset) {
        int n = dim.size;
        Record header = Record.create((int)n);
        for (int i = 0; i < n; ++i) {
            header.item(tensor[offset]);
            offset += dim.stride;
        }
        return Record.create((int)1).attr(this.tag(), (Value)header);
    }

    @Override
    public void castTensor(Item item, TensorDims dim, float[] tensor, int offset) {
        Value header = item.toValue().header(this.tag());
        if (header.isDefined()) {
            int n = header.length();
            if (n != dim.size || dim.next != null) {
                throw new DimensionException();
            }
            for (int i = 0; i < n; ++i) {
                tensor[offset] = header.getItem(i).floatValue(0.0f);
                offset += dim.stride;
            }
        }
    }

    @Override
    public void castTensor(Item item, TensorDims dim, double[] tensor, int offset) {
        Value header = item.toValue().header(this.tag());
        if (header.isDefined()) {
            int n = header.length();
            if (n != dim.size || dim.next != null) {
                throw new DimensionException();
            }
            for (int i = 0; i < n; ++i) {
                tensor[offset] = header.getItem(i).doubleValue(0.0);
                offset += dim.stride;
            }
        }
    }
}

