/*
 * Decompiled with CFR 0.152.
 */
package swim.client;

import swim.api.auth.Credentials;
import swim.api.auth.Identity;
import swim.api.client.ClientContext;
import swim.api.downlink.Downlink;
import swim.api.policy.Policy;
import swim.api.policy.PolicyDirective;
import swim.api.router.Router;
import swim.api.storage.Storage;
import swim.concurrent.Schedule;
import swim.concurrent.Stage;
import swim.concurrent.Theater;
import swim.io.TlsSettings;
import swim.io.http.HttpEndpoint;
import swim.io.http.HttpSettings;
import swim.remote.RemoteHostClient;
import swim.runtime.AbstractSwimRef;
import swim.runtime.HostBinding;
import swim.runtime.HttpBinding;
import swim.runtime.LaneBinding;
import swim.runtime.LinkBinding;
import swim.runtime.MeshBinding;
import swim.runtime.NodeBinding;
import swim.runtime.PartBinding;
import swim.runtime.PushRequest;
import swim.runtime.RootBinding;
import swim.runtime.RootContext;
import swim.runtime.RouterContext;
import swim.runtime.router.MeshTable;
import swim.runtime.router.PartTable;
import swim.runtime.router.RootTable;
import swim.runtime.router.TableRouter;
import swim.store.StorageContext;
import swim.store.StoreBinding;
import swim.store.mem.MemStorage;
import swim.structure.Value;
import swim.uri.Uri;

public class ClientRuntime
extends AbstractSwimRef
implements ClientContext,
RootContext {
    protected final Theater stage;
    protected final HttpEndpoint endpoint;
    protected final RootBinding root;
    RouterContext router;
    StorageContext storage;
    StoreBinding store;

    public ClientRuntime(Theater stage, HttpSettings settings) {
        this.stage = stage;
        this.endpoint = new HttpEndpoint((Stage)stage, settings);
        this.root = new RootTable();
        this.root.setRootContext((RootContext)this);
        this.router = new TableRouter();
        this.storage = new MemStorage();
    }

    public ClientRuntime(Theater stage) {
        this(stage, HttpSettings.standard().tlsSettings(TlsSettings.standard()));
    }

    public ClientRuntime() {
        this(new Theater());
    }

    public final RouterContext router() {
        return this.router;
    }

    public void setRouter(Router router) {
        if (!(router instanceof RouterContext)) {
            throw new IllegalArgumentException(router.toString());
        }
        this.router = (RouterContext)router;
    }

    public final StorageContext storage() {
        return this.storage;
    }

    public void setStorage(Storage storage) {
        if (!(storage instanceof StorageContext)) {
            throw new IllegalArgumentException(storage.toString());
        }
        this.storage = (StorageContext)storage;
        this.store = this.storage.createStore();
    }

    public void start() {
        this.stage.start();
        this.endpoint.start();
        this.root.start();
    }

    public void stop() {
        this.endpoint.stop();
        this.stage.stop();
    }

    public Uri meshUri() {
        return Uri.empty();
    }

    public Policy policy() {
        return null;
    }

    public Schedule schedule() {
        return this.stage;
    }

    public final Stage stage() {
        return this.stage;
    }

    public final StoreBinding store() {
        return this.store;
    }

    public final HttpEndpoint endpoint() {
        return this.endpoint;
    }

    public MeshBinding createMesh(Uri meshUri) {
        return new MeshTable();
    }

    public MeshBinding injectMesh(Uri meshUri, MeshBinding mesh) {
        return mesh;
    }

    public PartBinding createPart(Uri meshUri, Value partKey) {
        return new PartTable();
    }

    public PartBinding injectPart(Uri meshUri, Value partKey, PartBinding part) {
        return part;
    }

    public HostBinding createHost(Uri meshUri, Value partKey, Uri hostUri) {
        return new RemoteHostClient(hostUri, this.endpoint);
    }

    public HostBinding injectHost(Uri meshUri, Value partKey, Uri hostUri, HostBinding host) {
        return host;
    }

    public NodeBinding createNode(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri) {
        return null;
    }

    public NodeBinding injectNode(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, NodeBinding node) {
        return node;
    }

    public LaneBinding injectLane(Uri meshUri, Value partKey, Uri hostUri, Uri nodeUri, Uri laneUri, LaneBinding lane) {
        return lane;
    }

    public PolicyDirective<Identity> authenticate(Credentials credentials) {
        return null;
    }

    public LinkBinding bindDownlink(Downlink downlink) {
        return this.root.bindDownlink(downlink);
    }

    public void openDownlink(LinkBinding link) {
        this.root.openDownlink(link);
    }

    public void closeDownlink(LinkBinding link) {
    }

    public void httpDownlink(HttpBinding http) {
        this.root.httpDownlink(http);
    }

    public void pushDown(PushRequest pushRequest) {
        this.root.pushDown(pushRequest);
    }

    public void trace(Object message) {
    }

    public void debug(Object message) {
    }

    public void info(Object message) {
    }

    public void warn(Object message) {
    }

    public void error(Object message) {
    }

    public void close() {
    }

    public void willOpen() {
    }

    public void didOpen() {
    }

    public void willLoad() {
    }

    public void didLoad() {
    }

    public void willStart() {
    }

    public void didStart() {
    }

    public void willStop() {
    }

    public void didStop() {
    }

    public void willUnload() {
    }

    public void didUnload() {
    }

    public void willClose() {
    }
}

