/*
 * Decompiled with CFR 0.152.
 */
package swim.remote;

import swim.collections.FingerTrieSeq;
import swim.concurrent.TimerFunction;
import swim.concurrent.TimerRef;
import swim.io.http.HttpClient;
import swim.io.http.HttpEndpoint;
import swim.io.warp.WarpSettings;
import swim.io.warp.WarpSocket;
import swim.io.warp.WarpWebSocket;
import swim.remote.RemoteHost;
import swim.remote.RemoteHostClientBinding;
import swim.remote.RemoteHostClientReconnectTimer;
import swim.runtime.HostContext;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriPath;
import swim.uri.UriQuery;
import swim.uri.UriScheme;
import swim.ws.WsRequest;

public class RemoteHostClient
extends RemoteHost {
    final HttpEndpoint endpoint;
    final WarpSettings warpSettings;
    TimerRef reconnectTimer;
    double reconnectTimeout;
    static final double MAX_RECONNECT_TIMEOUT = 15000.0;
    static final FingerTrieSeq<String> PROTOCOL_LIST = FingerTrieSeq.of((Object)"warp0", (Object)"swim-0.0");

    public RemoteHostClient(Uri baseUri, HttpEndpoint endpoint, WarpSettings warpSettings) {
        super(Uri.empty(), baseUri);
        this.endpoint = endpoint;
        this.warpSettings = warpSettings;
    }

    public RemoteHostClient(Uri baseUri, HttpEndpoint endpoint) {
        this(baseUri, endpoint, WarpSettings.standard());
    }

    @Override
    public void setHostContext(HostContext hostContext) {
        super.setHostContext(hostContext);
        this.connect();
    }

    public void connect() {
        String scheme = this.baseUri.schemeName();
        boolean isSecure = "swims".equals(scheme);
        UriAuthority remoteAuthority = this.baseUri.authority();
        String remoteAddress = remoteAuthority.host().address();
        int remotePort = remoteAuthority.port().number();
        Uri requestUri = Uri.from((UriScheme)UriScheme.from((String)"http"), (UriAuthority)remoteAuthority, (UriPath)UriPath.slash(), (UriQuery)this.baseUri.query());
        int requestPort = remotePort > 0 ? remotePort : (isSecure ? 443 : 80);
        WsRequest wsRequest = WsRequest.from((Uri)requestUri, PROTOCOL_LIST);
        WarpWebSocket warpWebSocket = new WarpWebSocket((WarpSocket)this, this.warpSettings);
        RemoteHostClientBinding client = new RemoteHostClientBinding(this, warpWebSocket, wsRequest, this.warpSettings);
        if (isSecure) {
            this.endpoint.connectHttps(remoteAddress, requestPort, (HttpClient)client, this.warpSettings.httpSettings());
        } else {
            this.endpoint.connectHttp(remoteAddress, requestPort, (HttpClient)client, this.warpSettings.httpSettings());
        }
    }

    @Override
    protected void reconnect() {
        if (this.reconnectTimer != null && this.reconnectTimer.isScheduled()) {
            return;
        }
        if (this.reconnectTimeout == 0.0) {
            double jitter = 1000.0 * Math.random();
            this.reconnectTimeout = 500.0 + jitter;
        } else {
            this.reconnectTimeout = Math.min(1.8 * this.reconnectTimeout, 15000.0);
        }
        this.reconnectTimer = this.hostContext.schedule().setTimer((long)this.reconnectTimeout, (TimerFunction)new RemoteHostClientReconnectTimer(this));
    }

    @Override
    public void didConnect() {
        if (this.reconnectTimer != null) {
            this.reconnectTimer.cancel();
            this.reconnectTimer = null;
        }
        this.reconnectTimeout = 0.0;
        super.didConnect();
    }
}

