/*
 * Decompiled with CFR 0.152.
 */
package swim.decipher;

import swim.codec.Decoder;
import swim.codec.Parser;
import swim.decipher.DecipherDecoder;
import swim.decipher.DecipherParser;
import swim.decipher.DecipherStructureDecoder;
import swim.decipher.DecipherStructureParser;
import swim.structure.Item;
import swim.structure.Value;

public final class Decipher {
    private static DecipherDecoder<Item, Value> structureDecoder;
    private static DecipherParser<Item, Value> structureParser;

    private Decipher() {
    }

    static boolean isSpace(int c) {
        return c == 32 || c == 9;
    }

    static boolean isNewline(int c) {
        return c == 10 || c == 13;
    }

    static boolean isWhitespace(int c) {
        return Decipher.isSpace(c) || Decipher.isNewline(c);
    }

    public static DecipherDecoder<Item, Value> structureDecoder() {
        if (structureDecoder == null) {
            structureDecoder = new DecipherStructureDecoder();
        }
        return structureDecoder;
    }

    public static DecipherParser<Item, Value> structureParser() {
        if (structureParser == null) {
            structureParser = new DecipherStructureParser();
        }
        return structureParser;
    }

    public static Value parse(String any) {
        return Decipher.structureParser().parseAnyString(any);
    }

    public static Parser<Value> parser() {
        return Decipher.structureParser().anyParser();
    }

    public static Decoder<Value> decoder() {
        return Decipher.structureDecoder().anyDecoder();
    }
}

