/*
 * Decompiled with CFR 0.152.
 */
package swim.structure.selector;

import java.util.ListIterator;
import swim.codec.Output;
import swim.structure.Interpreter;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Selectee;
import swim.structure.Selector;
import swim.structure.Value;
import swim.util.Murmur3;

public class DescendantsSelector
extends Selector {
    final Selector then;
    private static int hashSeed;

    DescendantsSelector(Selector then) {
        this.then = then;
    }

    @Override
    public Selector then() {
        return this.then;
    }

    @Override
    public <T> T forSelected(Interpreter interpreter, Selectee<T> callback) {
        T selected = null;
        interpreter.willSelect(this);
        if (interpreter.scopeDepth() != 0) {
            Value scope = interpreter.popScope().toValue();
            if (scope instanceof Record) {
                ListIterator<Item> children = ((Record)scope).listIterator();
                while (selected == null && children.hasNext()) {
                    Item child = children.next();
                    interpreter.pushScope(child);
                    selected = this.then.forSelected(interpreter, callback);
                    if (selected == null) {
                        this.forSelected(interpreter, callback);
                    }
                    interpreter.popScope();
                }
            }
            interpreter.pushScope(scope);
        }
        interpreter.didSelect(this, selected);
        return selected;
    }

    @Override
    public Item mapSelected(Interpreter interpreter, Selectee<Item> transform) {
        Item result;
        interpreter.willTransform(this);
        if (interpreter.scopeDepth() != 0) {
            Value scope = interpreter.popScope().toValue();
            if (scope instanceof Record) {
                ListIterator<Item> children = ((Record)scope).listIterator();
                while (children.hasNext()) {
                    Item oldChild = children.next();
                    interpreter.pushScope(oldChild);
                    Item newChild = this.then.mapSelected(interpreter, transform);
                    if (newChild.isDefined()) {
                        newChild = this.mapSelected(interpreter, transform);
                    }
                    interpreter.popScope();
                    if (newChild.isDefined()) {
                        if (newChild == oldChild) continue;
                        children.set(newChild);
                        continue;
                    }
                    children.remove();
                }
            }
            interpreter.pushScope(scope);
            result = scope;
        } else {
            result = Item.absent();
        }
        interpreter.didTransform(this, result);
        return result;
    }

    @Override
    public Item substitute(Interpreter interpreter) {
        Item then = this.then.substitute(interpreter);
        if (!(then instanceof Selector)) {
            then = this.then;
        }
        return new DescendantsSelector((Selector)then);
    }

    @Override
    public Selector andThen(Selector then) {
        return new DescendantsSelector(this.then.andThen(then));
    }

    @Override
    public int typeOrder() {
        return 18;
    }

    @Override
    protected int compareTo(Selector that) {
        if (that instanceof DescendantsSelector) {
            return this.compareTo((DescendantsSelector)that);
        }
        return Integer.compare(this.typeOrder(), that.typeOrder());
    }

    @Override
    int compareTo(DescendantsSelector that) {
        return this.then.compareTo((Item)that.then);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DescendantsSelector) {
            DescendantsSelector that = (DescendantsSelector)other;
            return this.then.equals(that.then);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(DescendantsSelector.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.then.hashCode()));
    }

    @Override
    public void debugThen(Output<?> output) {
        output = output.write(46).write("descendants").write(40).write(41);
        this.then.debugThen(output);
    }
}

