/*
 * Decompiled with CFR 0.152.
 */
package swim.warp;

import swim.codec.Debug;
import swim.codec.Decoder;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.Writer;
import swim.recon.Recon;
import swim.structure.Form;
import swim.structure.Item;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.AuthRequest;
import swim.warp.AuthedResponse;
import swim.warp.CommandMessage;
import swim.warp.DeauthRequest;
import swim.warp.DeauthedResponse;
import swim.warp.EnvelopeDecoder;
import swim.warp.EnvelopeEncoder;
import swim.warp.EventMessage;
import swim.warp.LinkRequest;
import swim.warp.LinkedResponse;
import swim.warp.SyncRequest;
import swim.warp.SyncedResponse;
import swim.warp.UnlinkRequest;
import swim.warp.UnlinkedResponse;

public abstract class Envelope
implements Debug {
    private static Decoder<Envelope> decoder;
    private static Encoder<Envelope, Envelope> encoder;

    Envelope() {
    }

    public abstract String tag();

    public abstract Form<? extends Envelope> form();

    public abstract Uri nodeUri();

    public abstract Uri laneUri();

    public abstract Value body();

    public abstract Envelope nodeUri(Uri var1);

    public abstract Envelope laneUri(Uri var1);

    public abstract Envelope body(Value var1);

    public Value toValue() {
        return this.form().mold((Object)this).toValue();
    }

    public Encoder<?, Envelope> reconEncoder() {
        return new EnvelopeEncoder(this);
    }

    public Writer<?, ?> reconWriter() {
        return Recon.write((Item)this.toValue(), (Output)Output.full());
    }

    public Writer<?, ?> writeRecon(Output<?> output) {
        return Recon.write((Item)this.toValue(), output);
    }

    public String toRecon() {
        return Recon.toString((Item)this.toValue());
    }

    public abstract void debug(Output<?> var1);

    public String toString() {
        return Format.debug((Object)this);
    }

    public static Decoder<Envelope> decoder() {
        if (decoder == null) {
            decoder = new EnvelopeDecoder();
        }
        return decoder;
    }

    public static Encoder<Envelope, Envelope> encoder() {
        if (encoder == null) {
            encoder = new EnvelopeEncoder();
        }
        return encoder;
    }

    public static Envelope fromValue(Value value) {
        String tag = value.tag();
        Form form = Envelope.form(tag);
        if (form != null) {
            return (Envelope)form.cast((Item)value);
        }
        return null;
    }

    public static Envelope parseRecon(String recon) {
        Value value = Recon.parse((String)recon);
        return Envelope.fromValue(value);
    }

    public static <E extends Envelope> Form<E> form(String tag) {
        if ("event".equals(tag)) {
            return EventMessage.FORM;
        }
        if ("command".equals(tag)) {
            return CommandMessage.FORM;
        }
        if ("link".equals(tag)) {
            return LinkRequest.FORM;
        }
        if ("linked".equals(tag)) {
            return LinkedResponse.FORM;
        }
        if ("sync".equals(tag)) {
            return SyncRequest.FORM;
        }
        if ("synced".equals(tag)) {
            return SyncedResponse.FORM;
        }
        if ("unlink".equals(tag)) {
            return UnlinkRequest.FORM;
        }
        if ("unlinked".equals(tag)) {
            return UnlinkedResponse.FORM;
        }
        if ("auth".equals(tag)) {
            return AuthRequest.FORM;
        }
        if ("authed".equals(tag)) {
            return AuthedResponse.FORM;
        }
        if ("deauth".equals(tag)) {
            return DeauthRequest.FORM;
        }
        if ("deauthed".equals(tag)) {
            return DeauthedResponse.FORM;
        }
        return null;
    }
}

