/*
 * Decompiled with CFR 0.152.
 */
package swim.warp;

import swim.structure.Form;
import swim.structure.Kind;
import swim.structure.Value;
import swim.uri.Uri;
import swim.warp.LaneAddressed;
import swim.warp.SyncedResponseForm;

public final class SyncedResponse
extends LaneAddressed {
    @Kind
    public static final Form<SyncedResponse> FORM = new SyncedResponseForm();

    public SyncedResponse(Uri nodeUri, Uri laneUri, Value body) {
        super(nodeUri, laneUri, body);
    }

    public SyncedResponse(Uri nodeUri, Uri laneUri) {
        this(nodeUri, laneUri, Value.absent());
    }

    public SyncedResponse(String nodeUri, String laneUri, Value body) {
        this(Uri.parse((String)nodeUri), Uri.parse((String)laneUri), body);
    }

    public SyncedResponse(String nodeUri, String laneUri) {
        this(Uri.parse((String)nodeUri), Uri.parse((String)laneUri), Value.absent());
    }

    @Override
    public String tag() {
        return "synced";
    }

    public Form<SyncedResponse> form() {
        return FORM;
    }

    @Override
    public SyncedResponse nodeUri(Uri nodeUri) {
        return new SyncedResponse(nodeUri, this.laneUri, this.body);
    }

    @Override
    public SyncedResponse laneUri(Uri laneUri) {
        return new SyncedResponse(this.nodeUri, laneUri, this.body);
    }

    @Override
    public SyncedResponse body(Value body) {
        return new SyncedResponse(this.nodeUri, this.laneUri, body);
    }
}

