/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import java.util.Iterator;
import swim.codec.Base16;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;
import swim.http.ChunkExtension;
import swim.http.HttpWriter;

final class HttpChunkHeaderWriter
extends Writer<Object, Object> {
    final HttpWriter http;
    final long size;
    final Iterator<ChunkExtension> extensions;
    final Writer<?, ?> part;
    final int step;

    HttpChunkHeaderWriter(HttpWriter http, long size, Iterator<ChunkExtension> extensions, Writer<?, ?> part, int step) {
        this.http = http;
        this.size = size;
        this.extensions = extensions;
        this.part = part;
        this.step = step;
    }

    HttpChunkHeaderWriter(HttpWriter http, long size, Iterator<ChunkExtension> extensions) {
        this(http, size, extensions, null, 1);
    }

    public Writer<Object, Object> pull(Output<?> output) {
        return HttpChunkHeaderWriter.write(output, this.http, this.size, this.extensions, this.part, this.step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, long size, Iterator<ChunkExtension> extensions, Writer<?, ?> part, int step) {
        block14: {
            if (step == 1) {
                if ((part = part == null ? Base16.uppercase().writeLong(size, output) : part.pull(output)).isDone()) {
                    part = null;
                    step = 2;
                } else if (part.isError()) {
                    return part.asError();
                }
            }
            while (true) {
                if (step == 2) {
                    if (!extensions.hasNext()) {
                        step = 4;
                    } else if (output.isCont()) {
                        output = output.write(59);
                        step = 3;
                    }
                }
                if (step != 3) break block14;
                if (!(part = part == null ? extensions.next().writeHttp(output, http) : part.pull(output)).isDone()) break;
                part = null;
                step = 2;
            }
            if (part.isError()) {
                return part.asError();
            }
        }
        if (step == 4 && output.isCont()) {
            output = output.write(13);
            step = 5;
        }
        if (step == 5 && output.isCont()) {
            output = output.write(10);
            return HttpChunkHeaderWriter.done();
        }
        if (output.isDone()) {
            return HttpChunkHeaderWriter.error((Throwable)new WriterException("truncated"));
        }
        if (output.isError()) {
            return HttpChunkHeaderWriter.error((Throwable)output.trap());
        }
        return new HttpChunkHeaderWriter(http, size, extensions, (Writer<?, ?>)part, step);
    }

    static Writer<Object, Object> write(Output<?> output, HttpWriter http, long size, Iterator<ChunkExtension> extensions) {
        return HttpChunkHeaderWriter.write(output, http, size, extensions, null, 1);
    }
}

