/*
 * Decompiled with CFR 0.152.
 */
package swim.http.header;

import java.util.Map;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Writer;
import swim.collections.HashTrieMap;
import swim.http.HttpHeader;
import swim.http.HttpParser;
import swim.http.HttpWriter;
import swim.http.MediaType;
import swim.http.header.ContentTypeParser;
import swim.util.Murmur3;

public final class ContentType
extends HttpHeader {
    final MediaType mediaType;
    private static int hashSeed;

    ContentType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    @Override
    public String lowerCaseName() {
        return "content-type";
    }

    @Override
    public String name() {
        return "Content-Type";
    }

    public MediaType mediaType() {
        return this.mediaType;
    }

    public String type() {
        return this.mediaType.type();
    }

    public String subtype() {
        return this.mediaType.subtype();
    }

    public HashTrieMap<String, String> params() {
        return this.mediaType.params();
    }

    public String getParam(String key) {
        return this.mediaType.getParam(key);
    }

    public ContentType param(String key, String value) {
        return ContentType.from(this.mediaType.param(key, value));
    }

    @Override
    public Writer<?, ?> writeHttpValue(Output<?> output, HttpWriter http) {
        return this.mediaType.writeHttp(output, http);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ContentType) {
            ContentType that = (ContentType)other;
            return this.mediaType.equals(that.mediaType);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(ContentType.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)this.mediaType.hashCode()));
    }

    public void debug(Output<?> output) {
        output = output.write("ContentType").write(46).write("from").write(40).debug((Object)this.mediaType.type()).write(", ").write(this.mediaType.subtype()).write(41);
        for (Map.Entry param : this.mediaType.params()) {
            output = output.write(46).write("param").write(40).debug(param.getKey()).write(", ").debug(param.getValue()).write(41);
        }
    }

    public static ContentType from(MediaType mediaType) {
        return new ContentType(mediaType);
    }

    public static ContentType from(String type, String subtype, HashTrieMap<String, String> params) {
        return ContentType.from(MediaType.from(type, subtype, params));
    }

    public static ContentType from(String type, String subtype) {
        return ContentType.from(MediaType.from(type, subtype));
    }

    public static ContentType from(String mediaType) {
        return ContentType.from(MediaType.parse(mediaType));
    }

    public static Parser<ContentType> parseHttpValue(Input input, HttpParser http) {
        return ContentTypeParser.parse(input, http);
    }
}

