/*
 * Decompiled with CFR 0.152.
 */
package swim.args;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.util.Murmur3;

public class Arg
implements Cloneable,
Debug {
    final String name;
    String value;
    boolean optional;
    private static int hashSeed;

    public Arg(String name, String value, boolean optional) {
        this.name = name;
        this.value = value;
        this.optional = optional;
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public Arg value(String value) {
        this.value = value;
        return this;
    }

    public boolean optional() {
        return this.optional;
    }

    public Arg optional(boolean optional) {
        this.optional = optional;
        return this;
    }

    public boolean canEqual(Object other) {
        return other instanceof Arg;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Arg) {
            Arg that = (Arg)other;
            return that.canEqual(this) && this.name.equals(that.name) && (this.value == null ? that.value == null : this.value.equals(that.value)) && this.optional == that.optional;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(Arg.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.name.hashCode()), (int)Murmur3.hash((Object)this.value)), (int)Murmur3.hash((boolean)this.optional)));
    }

    public void debug(Output<?> output) {
        output = output.write("Arg").write(46).write("of").write(40).debug((Object)this.name);
        if (this.value != null) {
            output = output.write(", ").debug((Object)this.value);
        }
        output = output.write(41);
        if (this.optional) {
            output = output.write(46).write("optional").write(40).write("true").write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public Arg clone() {
        return new Arg(this.name, this.value, this.optional);
    }

    public static Arg of(String name, String value, boolean optional) {
        return new Arg(name, value, optional);
    }

    public static Arg of(String name, String value) {
        return new Arg(name, value, false);
    }

    public static Arg of(String name) {
        return new Arg(name, null, false);
    }
}

