/*
 * Decompiled with CFR 0.152.
 */
package swim.util;

import java.nio.ByteOrder;

public final class Murmur3 {
    private Murmur3() {
    }

    public static int seed(Class<?> clazz) {
        return Murmur3.seed(clazz.getName());
    }

    public static int seed(String string) {
        return Murmur3.mash(Murmur3.mix(0, string));
    }

    public static int hash(byte value) {
        return value;
    }

    public static int hash(short value) {
        return value;
    }

    public static int hash(int value) {
        return value;
    }

    public static int hash(long value) {
        return (int)value ^ (int)(value >>> 32) + (int)(value >>> 63);
    }

    public static int hash(float value) {
        if (value == (float)((int)value)) {
            return (int)value;
        }
        if (value == (float)((long)value)) {
            return Murmur3.hash((long)value);
        }
        return Float.floatToIntBits(value);
    }

    public static int hash(double value) {
        if (value == (double)((int)value)) {
            return (int)value;
        }
        if (value == (double)((long)value)) {
            return Murmur3.hash((long)value);
        }
        if (value == (double)((float)value)) {
            return Float.floatToIntBits((float)value);
        }
        long y = Double.doubleToLongBits(value);
        return (int)y ^ (int)(y >>> 32);
    }

    public static int hash(char value) {
        return value;
    }

    public static int hash(boolean value) {
        if (value) {
            return Boolean.TRUE.hashCode();
        }
        return Boolean.FALSE.hashCode();
    }

    public static int hash(Number number) {
        if (number instanceof Double) {
            return Murmur3.hash(number.doubleValue());
        }
        if (number instanceof Float) {
            return Murmur3.hash(number.floatValue());
        }
        if (number instanceof Long) {
            return Murmur3.hash(number.longValue());
        }
        return number.intValue();
    }

    public static int hash(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return Murmur3.hash((Number)object);
        }
        return object.hashCode();
    }

    public static int mix(int code, byte[] array, int offset, int size) {
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            return Murmur3.mixByteArrayBE(code, array, offset, size);
        }
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            return Murmur3.mixByteArrayLE(code, array, offset, size);
        }
        throw new AssertionError();
    }

    static int mixByteArrayBE(int code, byte[] array, int offset, int size) {
        int word;
        int limit = offset + size;
        while (offset + 3 < limit) {
            word = (array[offset] & 0xFF) << 24 | (array[offset + 1] & 0xFF) << 16 | (array[offset + 2] & 0xFF) << 8 | array[offset + 3] & 0xFF;
            code = Murmur3.mix(code, word);
            offset += 4;
        }
        if (offset < limit) {
            word = (array[offset] & 0xFF) << 24;
            if (offset + 1 < limit) {
                word |= (array[offset + 1] & 0xFF) << 16;
                if (offset + 2 < limit) {
                    word |= (array[offset + 2] & 0xFF) << 8;
                }
            }
            word *= -862048943;
            word = Integer.rotateLeft(word, 15);
            code ^= (word *= 461845907);
        }
        return code ^ size;
    }

    static int mixByteArrayLE(int code, byte[] array, int offset, int size) {
        int word;
        int limit = offset + size;
        while (offset + 3 < limit) {
            word = array[offset] & 0xFF | (array[offset + 1] & 0xFF) << 8 | (array[offset + 2] & 0xFF) << 16 | (array[offset + 3] & 0xFF) << 24;
            code = Murmur3.mix(code, word);
            offset += 4;
        }
        if (offset < limit) {
            word = array[offset] & 0xFF;
            if (offset + 1 < limit) {
                word |= (array[offset + 1] & 0xFF) << 8;
                if (offset + 2 < limit) {
                    word |= (array[offset + 2] & 0xFF) << 16;
                }
            }
            word *= -862048943;
            word = Integer.rotateLeft(word, 15);
            code ^= (word *= 461845907);
        }
        return code ^ size;
    }

    public static int mix(int code, byte[] array) {
        return Murmur3.mix(code, array, 0, array != null ? array.length : 0);
    }

    public static int mix(int code, String string) {
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            return Murmur3.mixStringBE(code, string);
        }
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            return Murmur3.mixStringLE(code, string);
        }
        throw new AssertionError();
    }

    static int mixStringBE(int code, String string) {
        int word = 0;
        int k = 32;
        int i = 0;
        int n = string != null ? string.length() : 0;
        int utf8Length = 0;
        while (i < n) {
            int c = string.codePointAt(i);
            if (c >= 0 && c <= 127) {
                word |= c << (k -= 8);
                if (k == 0) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 32;
                }
                ++utf8Length;
            } else if (c >= 128 && c <= 2047) {
                word |= (0xC0 | c >>> 6) << (k -= 8);
                if (k == 0) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 32;
                }
                word |= (0x80 | c & 0x3F) << (k -= 8);
                if (k == 0) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 32;
                }
                utf8Length += 2;
            } else if (c >= 2048 && c <= 65535) {
                word |= (0xE0 | c >>> 12) << (k -= 8);
                if (k == 0) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 32;
                }
                word |= (0x80 | c >>> 6 & 0x3F) << (k -= 8);
                if (k == 0) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 32;
                }
                word |= (0x80 | c & 0x3F) << (k -= 8);
                if (k == 0) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 32;
                }
                utf8Length += 3;
            } else if (c >= 65536 && c <= 0x10FFFF) {
                word |= (0xF0 | c >>> 18) << (k -= 8);
                if (k == 0) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 32;
                }
                word |= (0x80 | c >>> 12 & 0x3F) << (k -= 8);
                if (k == 0) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 32;
                }
                word |= (0x80 | c >>> 6 & 0x3F) << (k -= 8);
                if (k == 0) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 32;
                }
                word |= (0x80 | c & 0x3F) << (k -= 8);
                if (k == 0) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 32;
                }
                utf8Length += 4;
            } else {
                word |= 239 << (k -= 8);
                if (k == 0) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 32;
                }
                word |= 191 << (k -= 8);
                if (k == 0) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 32;
                }
                word |= 189 << (k -= 8);
                if (k == 0) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 32;
                }
                utf8Length += 3;
            }
            i = string.offsetByCodePoints(i, 1);
        }
        if (k != 32) {
            word *= -862048943;
            word = Integer.rotateLeft(word, 15);
            code ^= (word *= 461845907);
        }
        return code ^ utf8Length;
    }

    static int mixStringLE(int code, String string) {
        int word = 0;
        int k = 0;
        int i = 0;
        int n = string.length();
        int utf8Length = 0;
        while (i < n) {
            int c = string.codePointAt(i);
            if (c >= 0 && c <= 127) {
                word |= c << k;
                if ((k += 8) == 32) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 0;
                }
                ++utf8Length;
            } else if (c >= 128 && c <= 2047) {
                word |= (0xC0 | c >>> 6) << k;
                if ((k += 8) == 32) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 0;
                }
                word |= (0x80 | c & 0x3F) << k;
                if ((k += 8) == 32) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 0;
                }
                utf8Length += 2;
            } else if (c >= 2048 && c <= 65535) {
                word |= (0xE0 | c >>> 12) << k;
                if ((k += 8) == 32) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 0;
                }
                word |= (0x80 | c >>> 6 & 0x3F) << k;
                if ((k += 8) == 32) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 0;
                }
                word |= (0x80 | c & 0x3F) << k;
                if ((k += 8) == 32) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 0;
                }
                utf8Length += 3;
            } else if (c >= 65536 && c <= 0x10FFFF) {
                word |= (0xF0 | c >>> 18) << k;
                if ((k += 8) == 32) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 0;
                }
                word |= (0x80 | c >>> 12 & 0x3F) << k;
                if ((k += 8) == 32) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 0;
                }
                word |= (0x80 | c >>> 6 & 0x3F) << k;
                if ((k += 8) == 32) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 0;
                }
                word |= (0x80 | c & 0x3F) << k;
                if ((k += 8) == 32) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 0;
                }
                utf8Length += 4;
            } else {
                word |= 239 << k;
                if ((k += 8) == 32) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 0;
                }
                word |= 191 << k;
                if ((k += 8) == 32) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 0;
                }
                word |= 189 << k;
                if ((k += 8) == 32) {
                    code = Murmur3.mix(code, word);
                    word = 0;
                    k = 0;
                }
                utf8Length += 3;
            }
            i = string.offsetByCodePoints(i, 1);
        }
        if (k != 32) {
            word *= -862048943;
            word = Integer.rotateLeft(word, 15);
            code ^= (word *= 461845907);
        }
        return code ^ utf8Length;
    }

    public static int mix(int code, int value) {
        value *= -862048943;
        value = Integer.rotateLeft(value, 15);
        code ^= (value *= 461845907);
        code = Integer.rotateLeft(code, 13);
        code = code * 5 + -430675100;
        return code;
    }

    public static int mash(int code) {
        code ^= code >>> 16;
        code *= -2048144789;
        code ^= code >>> 13;
        code *= -1028477387;
        code ^= code >>> 16;
        return code;
    }
}

