/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.uri.Uri;
import swim.uri.UriAuthority;
import swim.uri.UriFragment;
import swim.uri.UriParser;
import swim.uri.UriPath;
import swim.uri.UriPathBuilder;
import swim.uri.UriQuery;
import swim.uri.UriScheme;

final class UriAbsoluteParser
extends Parser<Uri> {
    final UriParser uri;
    final Parser<UriScheme> schemeParser;
    final Parser<UriAuthority> authorityParser;
    final Parser<UriPath> pathParser;
    final Parser<UriQuery> queryParser;
    final Parser<UriFragment> fragmentParser;
    final int step;

    UriAbsoluteParser(UriParser uri, Parser<UriScheme> schemeParser, Parser<UriAuthority> authorityParser, Parser<UriPath> pathParser, Parser<UriQuery> queryParser, Parser<UriFragment> fragmentParser, int step) {
        this.uri = uri;
        this.schemeParser = schemeParser;
        this.authorityParser = authorityParser;
        this.pathParser = pathParser;
        this.queryParser = queryParser;
        this.fragmentParser = fragmentParser;
        this.step = step;
    }

    UriAbsoluteParser(UriParser uri) {
        this(uri, null, null, null, null, null, 1);
    }

    public Parser<Uri> feed(Input input) {
        return UriAbsoluteParser.parse(input, this.uri, this.schemeParser, this.authorityParser, this.pathParser, this.queryParser, this.fragmentParser, this.step);
    }

    static Parser<Uri> parse(Input input, UriParser uri, Parser<UriScheme> schemeParser, Parser<UriAuthority> authorityParser, Parser<UriPath> pathParser, Parser<UriQuery> queryParser, Parser<UriFragment> fragmentParser, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                Input look = input.clone();
                while (look.isCont() && Uri.isSchemeChar(c = look.head())) {
                    look = look.step();
                }
                step = look.isCont() && c == 58 ? 2 : 3;
            } else if (input.isDone()) {
                step = 3;
            }
        }
        if (step == 2) {
            if ((schemeParser = schemeParser == null ? uri.parseScheme(input) : schemeParser.feed(input)).isDone()) {
                if (input.isCont() && input.head() == 58) {
                    input = input.step();
                    step = 3;
                } else if (!input.isEmpty()) {
                    return UriAbsoluteParser.error((Diagnostic)Diagnostic.expected((int)58, (Input)input));
                }
            } else if (schemeParser.isError()) {
                return schemeParser.asError();
            }
        }
        if (step == 3) {
            if (input.isCont()) {
                c = input.head();
                if (c == 47) {
                    input = input.step();
                    step = 4;
                } else if (c == 63) {
                    input = input.step();
                    step = 7;
                } else if (c == 35) {
                    input = input.step();
                    step = 8;
                } else {
                    step = 6;
                }
            } else if (input.isDone()) {
                return UriAbsoluteParser.done((Object)uri.absolute(schemeParser != null ? (UriScheme)schemeParser.bind() : null, null, null, null, null));
            }
        }
        if (step == 4) {
            if (input.isCont() && input.head() == 47) {
                input = input.step();
                step = 5;
            } else if (input.isCont()) {
                UriPathBuilder pathBuilder = uri.pathBuilder();
                pathBuilder.addSlash();
                pathParser = uri.parsePath(input, pathBuilder);
                step = 6;
            } else if (input.isDone()) {
                return UriAbsoluteParser.done((Object)uri.absolute(schemeParser != null ? (UriScheme)schemeParser.bind() : null, null, UriPath.slash(), null, null));
            }
        }
        if (step == 5) {
            if ((authorityParser = authorityParser == null ? uri.parseAuthority(input) : authorityParser.feed(input)).isDone()) {
                if (input.isCont()) {
                    c = input.head();
                    if (c == 63) {
                        input = input.step();
                        step = 7;
                    } else if (c == 35) {
                        input = input.step();
                        step = 8;
                    } else {
                        step = 6;
                    }
                } else if (input.isDone()) {
                    return UriAbsoluteParser.done((Object)uri.absolute(schemeParser != null ? (UriScheme)schemeParser.bind() : null, (UriAuthority)authorityParser.bind(), null, null, null));
                }
            } else if (authorityParser.isError()) {
                return authorityParser.asError();
            }
        }
        if (step == 6) {
            if ((pathParser = pathParser == null ? uri.parsePath(input) : pathParser.feed(input)).isDone()) {
                if (input.isCont() && input.head() == 63) {
                    input = input.step();
                    step = 7;
                } else if (input.isCont() && input.head() == 35) {
                    input = input.step();
                    step = 8;
                } else if (!input.isEmpty()) {
                    return UriAbsoluteParser.done((Object)uri.absolute(schemeParser != null ? (UriScheme)schemeParser.bind() : null, authorityParser != null ? (UriAuthority)authorityParser.bind() : null, (UriPath)pathParser.bind(), null, null));
                }
            } else if (pathParser.isError()) {
                return pathParser.asError();
            }
        }
        if (step == 7) {
            if ((queryParser = queryParser == null ? uri.parseQuery(input) : queryParser.feed(input)).isDone()) {
                if (input.isCont() && input.head() == 35) {
                    input = input.step();
                    step = 8;
                } else if (!input.isEmpty()) {
                    return UriAbsoluteParser.done((Object)uri.absolute(schemeParser != null ? (UriScheme)schemeParser.bind() : null, authorityParser != null ? (UriAuthority)authorityParser.bind() : null, pathParser != null ? (UriPath)pathParser.bind() : null, (UriQuery)queryParser.bind(), null));
                }
            } else if (queryParser.isError()) {
                return queryParser.asError();
            }
        }
        if (step == 8) {
            if ((fragmentParser = fragmentParser == null ? uri.parseFragment(input) : fragmentParser.feed(input)).isDone()) {
                return UriAbsoluteParser.done((Object)uri.absolute(schemeParser != null ? (UriScheme)schemeParser.bind() : null, authorityParser != null ? (UriAuthority)authorityParser.bind() : null, pathParser != null ? (UriPath)pathParser.bind() : null, queryParser != null ? (UriQuery)queryParser.bind() : null, (UriFragment)fragmentParser.bind()));
            }
            if (fragmentParser.isError()) {
                return fragmentParser.asError();
            }
        }
        if (input.isError()) {
            return UriAbsoluteParser.error((Throwable)input.trap());
        }
        return new UriAbsoluteParser(uri, (Parser<UriScheme>)schemeParser, (Parser<UriAuthority>)authorityParser, pathParser, (Parser<UriQuery>)queryParser, (Parser<UriFragment>)fragmentParser, step);
    }

    static Parser<Uri> parse(Input input, UriParser uri) {
        return UriAbsoluteParser.parse(input, uri, null, null, null, null, null, 1);
    }
}

