/*
 * Decompiled with CFR 0.152.
 */
package swim.uri;

import java.util.Collection;
import java.util.Map;
import swim.uri.UriQuery;
import swim.util.EntryBuilder;

public final class UriQueryBuilder
implements EntryBuilder<String, String, UriQuery> {
    UriQuery first = UriQuery.undefined();
    UriQuery last = null;
    int size = 0;
    int aliased = 0;

    boolean isEmpty() {
        return this.size == 0;
    }

    public boolean add(String key, String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return this.addParam(key, value);
    }

    public boolean add(Map.Entry<String, String> param) {
        if (param == null) {
            throw new NullPointerException();
        }
        return this.addParam(param.getKey(), param.getValue());
    }

    public boolean addAll(Collection<? extends Map.Entry<String, String>> params) {
        if (params == null) {
            throw new NullPointerException();
        }
        boolean modified = false;
        for (Map.Entry<String, String> entry : params) {
            modified = this.add(entry) || modified;
        }
        return modified;
    }

    public boolean addAll(Map<? extends String, ? extends String> params) {
        if (params == null) {
            throw new NullPointerException();
        }
        if (params instanceof UriQuery) {
            return this.addQuery((UriQuery)params);
        }
        boolean modified = false;
        for (Map.Entry<? extends String, ? extends String> param : params.entrySet()) {
            modified = this.addParam(param.getKey(), param.getValue()) || modified;
        }
        return modified;
    }

    public UriQuery bind() {
        this.aliased = 0;
        return this.first;
    }

    public boolean addParam(String key, String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        UriQuery tail = UriQuery.param(key, value, UriQuery.undefined());
        int size = this.size;
        if (size == 0) {
            this.first = tail;
        } else {
            this.dealias(size - 1).setTail(tail);
        }
        this.last = tail;
        this.size = size + 1;
        ++this.aliased;
        return true;
    }

    public boolean addParam(String value) {
        return this.addParam(null, value);
    }

    public boolean addQuery(UriQuery query) {
        if (!query.isEmpty()) {
            UriQuery tail;
            int size = this.size;
            if (size == 0) {
                this.first = query;
            } else {
                this.dealias(size - 1).setTail(query);
            }
            ++size;
            while (!(tail = query.tail()).isEmpty()) {
                query = tail;
                ++size;
            }
            this.last = query;
            this.size = size;
            return true;
        }
        return false;
    }

    UriQuery dealias(int n) {
        int i;
        UriQuery xi = null;
        UriQuery xs = this.first;
        if (this.aliased <= n) {
            for (i = 0; i < this.aliased; ++i) {
                xi = xs;
                xs = xs.tail();
            }
            while (i <= n) {
                UriQuery xn = xs.dealias();
                if (i == 0) {
                    this.first = xn;
                } else {
                    xi.setTail(xn);
                }
                xi = xn;
                xs = xs.tail();
                ++i;
            }
            if (i == this.size) {
                this.last = xi;
            }
            this.aliased = i;
        } else if (n == 0) {
            xi = this.first;
        } else if (n == this.size - 1) {
            xi = this.last;
        } else {
            while (i <= n) {
                xi = xs;
                xs = xs.tail();
                ++i;
            }
        }
        return xi;
    }
}

