/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Decoder;
import swim.codec.InputBuffer;
import swim.collections.FingerTrieSeq;
import swim.mqtt.MqttConnAck;
import swim.mqtt.MqttConnAckDecoder;
import swim.mqtt.MqttConnect;
import swim.mqtt.MqttConnectDecoder;
import swim.mqtt.MqttDataDecoder;
import swim.mqtt.MqttDisconnect;
import swim.mqtt.MqttDisconnectDecoder;
import swim.mqtt.MqttEntity;
import swim.mqtt.MqttException;
import swim.mqtt.MqttPacket;
import swim.mqtt.MqttPacketDecoder;
import swim.mqtt.MqttPingReq;
import swim.mqtt.MqttPingReqDecoder;
import swim.mqtt.MqttPingResp;
import swim.mqtt.MqttPingRespDecoder;
import swim.mqtt.MqttPubAck;
import swim.mqtt.MqttPubAckDecoder;
import swim.mqtt.MqttPubComp;
import swim.mqtt.MqttPubCompDecoder;
import swim.mqtt.MqttPubRec;
import swim.mqtt.MqttPubRecDecoder;
import swim.mqtt.MqttPubRel;
import swim.mqtt.MqttPubRelDecoder;
import swim.mqtt.MqttPublish;
import swim.mqtt.MqttPublishDecoder;
import swim.mqtt.MqttStringDecoder;
import swim.mqtt.MqttSubAck;
import swim.mqtt.MqttSubAckDecoder;
import swim.mqtt.MqttSubStatus;
import swim.mqtt.MqttSubscribe;
import swim.mqtt.MqttSubscribeDecoder;
import swim.mqtt.MqttSubscription;
import swim.mqtt.MqttSubscriptionDecoder;
import swim.mqtt.MqttUnsubAck;
import swim.mqtt.MqttUnsubAckDecoder;
import swim.mqtt.MqttUnsubscribe;
import swim.mqtt.MqttUnsubscribeDecoder;
import swim.structure.Data;

public class MqttDecoder {
    public MqttConnect connect(int packetFlags, String protocolName, int protocolLevel, int connectFlags, int keepAlive, String clientId, String willTopic, Data willMessage, String username, Data password) {
        return MqttConnect.from(packetFlags, protocolName, protocolLevel, connectFlags, keepAlive, clientId, willTopic, willMessage, username, password);
    }

    public MqttConnAck connAck(int packetFlags, int connectFlags, int connectCode) {
        return MqttConnAck.from(packetFlags, connectFlags, connectCode);
    }

    public <T> MqttPublish<T> publish(int packetFlags, String topicName, int packetId, MqttEntity<T> payload) {
        return MqttPublish.from(packetFlags, topicName, packetId, payload);
    }

    public MqttPubAck pubAck(int packetFlags, int packetId) {
        return MqttPubAck.from(packetFlags, packetId);
    }

    public MqttPubRec pubRec(int packetFlags, int packetId) {
        return MqttPubRec.from(packetFlags, packetId);
    }

    public MqttPubRel pubRel(int packetFlags, int packetId) {
        return MqttPubRel.from(packetFlags, packetId);
    }

    public MqttPubComp pubComp(int packetFlags, int packetId) {
        return MqttPubComp.from(packetFlags, packetId);
    }

    public MqttSubscribe subscribe(int packetFlags, int packetId, FingerTrieSeq<MqttSubscription> subscriptions) {
        return MqttSubscribe.from(packetFlags, packetId, subscriptions);
    }

    public MqttSubAck subAck(int packetFlags, int packetId, FingerTrieSeq<MqttSubStatus> subscriptions) {
        return MqttSubAck.from(packetFlags, packetId, subscriptions);
    }

    public MqttUnsubscribe unsubscribe(int packetFlags, int packetId, FingerTrieSeq<String> topicNames) {
        return MqttUnsubscribe.from(packetFlags, packetId, topicNames);
    }

    public MqttUnsubAck unsubAck(int packetFlags, int packetId) {
        return MqttUnsubAck.from(packetFlags, packetId);
    }

    public MqttPingReq pingReq(int packetFlags) {
        return MqttPingReq.from(packetFlags);
    }

    public MqttPingResp pingResp(int packetFlags) {
        return MqttPingResp.from(packetFlags);
    }

    public MqttDisconnect disconnect(int packetFlags) {
        return MqttDisconnect.from(packetFlags);
    }

    public MqttSubscription subscription(String topicName, int flags) {
        return MqttSubscription.from(topicName, flags);
    }

    public MqttSubStatus subStatus(int code) {
        return MqttSubStatus.from(code);
    }

    public <T> Decoder<MqttPacket<T>> packetDecoder(Decoder<T> content) {
        return new MqttPacketDecoder<T>(this, content);
    }

    public <T> Decoder<MqttPacket<T>> decodePacket(Decoder<T> content, InputBuffer input) {
        return MqttPacketDecoder.decode(input, this, content);
    }

    public <T> Decoder<MqttPacket<T>> decodePacketType(int packetType, Decoder<T> content, InputBuffer input) {
        Object decoder;
        switch (packetType) {
            case 1: {
                decoder = this.decodeConnect(input);
                break;
            }
            case 2: {
                decoder = this.decodeConnAck(input);
                break;
            }
            case 3: {
                decoder = this.decodePublish(content, input);
                break;
            }
            case 4: {
                decoder = this.decodePubAck(input);
                break;
            }
            case 5: {
                decoder = this.decodePubRec(input);
                break;
            }
            case 6: {
                decoder = this.decodePubRel(input);
                break;
            }
            case 7: {
                decoder = this.decodePubComp(input);
                break;
            }
            case 8: {
                decoder = this.decodeSubscribe(input);
                break;
            }
            case 9: {
                decoder = this.decodeSubAck(input);
                break;
            }
            case 10: {
                decoder = this.decodeUnsubscribe(input);
                break;
            }
            case 11: {
                decoder = this.decodeUnsubAck(input);
                break;
            }
            case 12: {
                decoder = this.decodePingReq(input);
                break;
            }
            case 13: {
                decoder = this.decodePingResp(input);
                break;
            }
            case 14: {
                decoder = this.decodeDisconnect(input);
                break;
            }
            default: {
                return Decoder.error((Throwable)new MqttException("reserved packet type: " + packetType));
            }
        }
        return decoder;
    }

    public Decoder<MqttConnect> decodeConnect(InputBuffer input) {
        return MqttConnectDecoder.decode(input, this);
    }

    public Decoder<MqttConnAck> decodeConnAck(InputBuffer input) {
        return MqttConnAckDecoder.decode(input, this);
    }

    public <T> Decoder<MqttPublish<T>> decodePublish(Decoder<T> content, InputBuffer input) {
        return MqttPublishDecoder.decode(input, this, content);
    }

    public Decoder<MqttPubAck> decodePubAck(InputBuffer input) {
        return MqttPubAckDecoder.decode(input, this);
    }

    public Decoder<MqttPubRec> decodePubRec(InputBuffer input) {
        return MqttPubRecDecoder.decode(input, this);
    }

    public Decoder<MqttPubRel> decodePubRel(InputBuffer input) {
        return MqttPubRelDecoder.decode(input, this);
    }

    public Decoder<MqttPubComp> decodePubComp(InputBuffer input) {
        return MqttPubCompDecoder.decode(input, this);
    }

    public Decoder<MqttSubscribe> decodeSubscribe(InputBuffer input) {
        return MqttSubscribeDecoder.decode(input, this);
    }

    public Decoder<MqttSubAck> decodeSubAck(InputBuffer input) {
        return MqttSubAckDecoder.decode(input, this);
    }

    public Decoder<MqttUnsubscribe> decodeUnsubscribe(InputBuffer input) {
        return MqttUnsubscribeDecoder.decode(input, this);
    }

    public Decoder<MqttUnsubAck> decodeUnsubAck(InputBuffer input) {
        return MqttUnsubAckDecoder.decode(input, this);
    }

    public Decoder<MqttPingReq> decodePingReq(InputBuffer input) {
        return MqttPingReqDecoder.decode(input, this);
    }

    public Decoder<MqttPingResp> decodePingResp(InputBuffer input) {
        return MqttPingRespDecoder.decode(input, this);
    }

    public Decoder<MqttDisconnect> decodeDisconnect(InputBuffer input) {
        return MqttDisconnectDecoder.decode(input, this);
    }

    public Decoder<MqttSubscription> subscriptionDecoder() {
        return new MqttSubscriptionDecoder(this);
    }

    public Decoder<MqttSubscription> decodeSubscription(InputBuffer input) {
        return MqttSubscriptionDecoder.decode(input, this);
    }

    public Decoder<String> stringDecoder() {
        return new MqttStringDecoder();
    }

    public Decoder<String> decodeString(InputBuffer input) {
        return MqttStringDecoder.decode(input);
    }

    public Decoder<Data> dataDecoder() {
        return new MqttDataDecoder();
    }

    public Decoder<Data> decodeData(InputBuffer input) {
        return MqttDataDecoder.decode(input);
    }
}

