/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Encoder;
import swim.codec.EncoderException;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttException;
import swim.mqtt.MqttPingReq;

final class MqttPingReqEncoder
extends Encoder<Object, MqttPingReq> {
    final MqttEncoder mqtt;
    final MqttPingReq packet;
    final int length;
    final int remaining;
    final int step;

    MqttPingReqEncoder(MqttEncoder mqtt, MqttPingReq packet, int length, int remaining, int step) {
        this.mqtt = mqtt;
        this.packet = packet;
        this.length = length;
        this.remaining = remaining;
        this.step = step;
    }

    MqttPingReqEncoder(MqttEncoder mqtt, MqttPingReq packet) {
        this(mqtt, packet, 0, 0, 1);
    }

    public Encoder<Object, MqttPingReq> pull(OutputBuffer<?> output) {
        return MqttPingReqEncoder.encode(output, this.mqtt, this.packet, this.length, this.remaining, this.step);
    }

    static Encoder<Object, MqttPingReq> encode(OutputBuffer<?> output, MqttEncoder mqtt, MqttPingReq packet, int length, int remaining, int step) {
        if (step == 1 && output.isCont()) {
            remaining = length = packet.bodySize(mqtt);
            output = output.write(packet.packetType() << 4 | packet.packetFlags & 0xF);
            step = 2;
        }
        while (step >= 2 && step <= 5 && output.isCont()) {
            int b = length & 0x7F;
            if ((length >>>= 7) > 0) {
                b |= 0x80;
            }
            output = output.write(b);
            if (length == 0) {
                step = 6;
                break;
            }
            if (step < 5) {
                ++step;
                continue;
            }
            return MqttPingReqEncoder.error((Throwable)new MqttException("packet length too long: " + remaining));
        }
        if (step == 6 && remaining == 0) {
            return MqttPingReqEncoder.done((Object)packet);
        }
        if (remaining < 0) {
            return MqttPingReqEncoder.error((Throwable)new MqttException("packet length too short"));
        }
        if (output.isDone()) {
            return MqttPingReqEncoder.error((Throwable)new EncoderException("truncated"));
        }
        if (output.isError()) {
            return MqttPingReqEncoder.error((Throwable)output.trap());
        }
        return new MqttPingReqEncoder(mqtt, packet, length, remaining, step);
    }

    static Encoder<Object, MqttPingReq> encode(OutputBuffer<?> output, MqttEncoder mqtt, MqttPingReq packet) {
        return MqttPingReqEncoder.encode(output, mqtt, packet, 0, 0, 1);
    }
}

