/*
 * Decompiled with CFR 0.152.
 */
package swim.mqtt;

import swim.codec.Debug;
import swim.codec.Encoder;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.mqtt.MqttEncoder;
import swim.mqtt.MqttPacket;
import swim.util.Murmur3;

public final class MqttUnsubAck
extends MqttPacket<Object>
implements Debug {
    final int packetFlags;
    final int packetId;
    private static int hashSeed;

    MqttUnsubAck(int packetFlags, int packetId) {
        this.packetFlags = packetFlags;
        this.packetId = packetId;
    }

    @Override
    public int packetType() {
        return 11;
    }

    @Override
    public int packetFlags() {
        return this.packetFlags;
    }

    public MqttUnsubAck packetFlags(int packetFlags) {
        return new MqttUnsubAck(packetFlags, this.packetId);
    }

    public int packetId() {
        return this.packetId;
    }

    public MqttUnsubAck packetId(int packetId) {
        return new MqttUnsubAck(this.packetFlags, packetId);
    }

    @Override
    int bodySize(MqttEncoder mqtt) {
        return 2;
    }

    public Encoder<?, MqttUnsubAck> mqttEncoder(MqttEncoder mqtt) {
        return mqtt.unsubAckEncoder(this);
    }

    public Encoder<?, MqttUnsubAck> encodeMqtt(OutputBuffer<?> output, MqttEncoder mqtt) {
        return mqtt.encodeUnsubAck(this, output);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MqttUnsubAck) {
            MqttUnsubAck that = (MqttUnsubAck)other;
            return this.packetFlags == that.packetFlags && this.packetId == that.packetId;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(MqttUnsubAck.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.packetFlags), (int)this.packetId));
    }

    public void debug(Output<?> output) {
        output = output.write("MqttUnsubAck").write(46).write("from").write(40).debug((Object)this.packetId).write(41);
        if (this.packetFlags != 0) {
            output = output.write(46).write("packetFlags").write(40).debug((Object)this.packetFlags).write(41);
        }
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static MqttUnsubAck from(int packetFlags, int packetId) {
        return new MqttUnsubAck(packetFlags, packetId);
    }

    public static MqttUnsubAck from(int packetId) {
        return new MqttUnsubAck(0, packetId);
    }
}

