/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import swim.deflate.Deflate;
import swim.deflate.Inflate;
import swim.ws.WsDecoder;
import swim.ws.WsDeflateDecoder;
import swim.ws.WsDeflateEncoder;
import swim.ws.WsDeflateEncoderMasked;
import swim.ws.WsDeflateEncoderUnmasked;
import swim.ws.WsEncoder;
import swim.ws.WsStandardDecoder;
import swim.ws.WsStandardEncoderMasked;
import swim.ws.WsStandardEncoderUnmasked;

public final class Ws {
    private static WsDecoder standardDecoder;
    private static WsEncoder standardEncoderMasked;
    private static WsEncoder standardEncoderUnmasked;

    private Ws() {
    }

    public static WsDecoder standardDecoder() {
        if (standardDecoder == null) {
            standardDecoder = new WsStandardDecoder();
        }
        return standardDecoder;
    }

    public static WsEncoder standardEncoderMasked() {
        if (standardEncoderMasked == null) {
            standardEncoderMasked = new WsStandardEncoderMasked();
        }
        return standardEncoderMasked;
    }

    public static WsEncoder standardEncoderUnmasked() {
        if (standardEncoderUnmasked == null) {
            standardEncoderUnmasked = new WsStandardEncoderUnmasked();
        }
        return standardEncoderUnmasked;
    }

    public static WsDeflateDecoder deflateDecoder(Inflate<?> inflate) {
        return new WsDeflateDecoder(inflate);
    }

    public static WsDeflateDecoder deflateDecoder() {
        return new WsDeflateDecoder(new Inflate());
    }

    public static WsDeflateEncoder deflateEncoderMasked(Deflate<?> deflate, int flush) {
        return new WsDeflateEncoderMasked(deflate, flush);
    }

    public static WsDeflateEncoder deflateEncoderMasked() {
        return new WsDeflateEncoderMasked(new Deflate(), 2);
    }

    public static WsDeflateEncoder deflateEncoderUnmasked(Deflate<?> deflate, int flush) {
        return new WsDeflateEncoderUnmasked(deflate, flush);
    }

    public static WsDeflateEncoder deflateEncoderUnmasked() {
        return new WsDeflateEncoderUnmasked(new Deflate(), 2);
    }
}

