/*
 * Decompiled with CFR 0.152.
 */
package swim.ws;

import swim.deflate.Deflate;
import swim.deflate.Inflate;
import swim.http.WebSocketExtension;
import swim.http.WebSocketParam;
import swim.ws.Ws;
import swim.ws.WsDecoder;
import swim.ws.WsEncoder;
import swim.ws.WsEngine;
import swim.ws.WsEngineSettings;
import swim.ws.WsException;

final class WsDeflateServerEngine
extends WsEngine {
    protected final int serverCompressionLevel;
    protected final boolean serverNoContextTakeover;
    protected final int serverMaxWindowBits;
    protected final int clientMaxWindowBits;

    WsDeflateServerEngine(int serverCompressionLevel, boolean serverNoContextTakeover, int serverMaxWindowBits, int clientMaxWindowBits) {
        this.serverCompressionLevel = serverCompressionLevel;
        this.serverNoContextTakeover = serverNoContextTakeover;
        this.serverMaxWindowBits = serverMaxWindowBits;
        this.clientMaxWindowBits = clientMaxWindowBits;
    }

    @Override
    public WsDecoder decoder() {
        return Ws.deflateDecoder(new Inflate(0, this.clientMaxWindowBits));
    }

    @Override
    public WsEncoder encoder() {
        int flush = this.serverNoContextTakeover ? 3 : 2;
        return Ws.deflateEncoderUnmasked(new Deflate(0, this.serverCompressionLevel, this.serverMaxWindowBits), flush);
    }

    @Override
    public WsEngine extension(WebSocketExtension extension, WsEngineSettings settings) {
        return this;
    }

    static WsDeflateServerEngine from(WebSocketExtension extension, WsEngineSettings settings) {
        boolean serverNoContextTakeover = false;
        int serverMaxWindowBits = 15;
        int clientMaxWindowBits = 15;
        for (WebSocketParam param : extension.params()) {
            String key = param.key();
            String value = param.value();
            if ("server_no_context_takeover".equals(key)) {
                serverNoContextTakeover = true;
                continue;
            }
            if ("server_max_window_bits".equals(key)) {
                try {
                    serverMaxWindowBits = Integer.parseInt(value);
                    continue;
                }
                catch (NumberFormatException cause) {
                    throw new WsException("invalid permessage-deflate; " + param.toHttp());
                }
            }
            if ("client_max_window_bits".equals(key)) {
                try {
                    clientMaxWindowBits = Integer.parseInt(value);
                    continue;
                }
                catch (NumberFormatException cause) {
                    throw new WsException("invalid permessage-deflate; " + param.toHttp());
                }
            }
            throw new WsException("invalid permessage-deflate; " + param.toHttp());
        }
        return new WsDeflateServerEngine(settings.serverCompressionLevel, serverNoContextTakeover, serverMaxWindowBits, clientMaxWindowBits);
    }
}

