/*
 * Decompiled with CFR 0.152.
 */
package swim.decipher;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.codec.Unicode;
import swim.decipher.AnyParser;
import swim.decipher.Decipher;

public abstract class DecipherParser<I, V> {
    public abstract Parser<V> parseXml(Input var1);

    public abstract Parser<V> parseJson(Input var1);

    public abstract Parser<V> parseRecon(Input var1);

    public Parser<V> parseAny(Input input) {
        return AnyParser.parse(input, this);
    }

    public Parser<V> anyParser() {
        return new AnyParser(this);
    }

    public V parseAnyString(String string) {
        Input input = Unicode.stringInput((String)string);
        while (input.isCont() && Decipher.isWhitespace(input.head())) {
            input = input.step();
        }
        Parser parser = this.parseAny(input);
        if (parser.isDone()) {
            while (input.isCont() && Decipher.isWhitespace(input.head())) {
                input = input.step();
            }
        }
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        } else if (input.isError()) {
            parser = Parser.error((Throwable)input.trap());
        }
        return (V)parser.bind();
    }
}

