/*
 * Decompiled with CFR 0.152.
 */
package swim.http;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.http.Http;
import swim.http.HttpParser;
import swim.http.UpgradeProtocol;

final class UpgradeProtocolParser
extends Parser<UpgradeProtocol> {
    final HttpParser http;
    final StringBuilder name;
    final StringBuilder version;
    final int step;

    UpgradeProtocolParser(HttpParser http, StringBuilder name, StringBuilder version, int step) {
        this.http = http;
        this.name = name;
        this.version = version;
        this.step = step;
    }

    UpgradeProtocolParser(HttpParser http) {
        this(http, null, null, 1);
    }

    public Parser<UpgradeProtocol> feed(Input input) {
        return UpgradeProtocolParser.parse(input, this.http, this.name, this.version, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<UpgradeProtocol> parse(Input input, HttpParser http, StringBuilder name, StringBuilder version, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (!Http.isTokenChar(c)) return UpgradeProtocolParser.error((Diagnostic)Diagnostic.expected((String)"upgrade protocol name", (Input)input));
                input = input.step();
                if (name == null) {
                    name = new StringBuilder();
                }
                name.appendCodePoint(c);
                step = 2;
            } else if (input.isDone()) {
                return UpgradeProtocolParser.error((Diagnostic)Diagnostic.expected((String)"upgrade protocol name", (Input)input));
            }
        }
        if (step == 2) {
            while (input.isCont() && Http.isTokenChar(c = input.head())) {
                input = input.step();
                name.appendCodePoint(c);
            }
            if (input.isCont() && c == 47) {
                input = input.step();
                step = 3;
            } else if (!input.isEmpty()) {
                return UpgradeProtocolParser.done((Object)http.upgradeProtocol(name.toString(), ""));
            }
        }
        if (step == 3) {
            if (input.isCont()) {
                c = input.head();
                if (!Http.isTokenChar(c)) return UpgradeProtocolParser.error((Diagnostic)Diagnostic.expected((String)"upgrade protocol version", (Input)input));
                input = input.step();
                if (version == null) {
                    version = new StringBuilder();
                }
                version.appendCodePoint(c);
                step = 4;
            } else if (input.isDone()) {
                return UpgradeProtocolParser.error((Diagnostic)Diagnostic.expected((String)"upgrade protocol version", (Input)input));
            }
        }
        if (step == 4) {
            while (input.isCont() && Http.isTokenChar(c = input.head())) {
                input = input.step();
                version.appendCodePoint(c);
            }
            if (!input.isEmpty()) {
                return UpgradeProtocolParser.done((Object)http.upgradeProtocol(name.toString(), version.toString()));
            }
        }
        if (!input.isError()) return new UpgradeProtocolParser(http, name, version, step);
        return UpgradeProtocolParser.error((Throwable)input.trap());
    }

    static Parser<UpgradeProtocol> parse(Input input, HttpParser http) {
        return UpgradeProtocolParser.parse(input, http, null, null, 1);
    }
}

