/*
 * Decompiled with CFR 0.152.
 */
package swim.math;

import java.lang.reflect.Array;
import swim.math.DimensionException;
import swim.math.TensorArrayIdentityForm;
import swim.math.TensorDims;
import swim.math.TensorForm;
import swim.structure.Item;
import swim.structure.Record;
import swim.structure.Value;

public abstract class TensorArrayForm<T, V>
extends TensorForm<T> {
    public abstract TensorForm<V> next();

    public abstract T fromArray(Object ... var1);

    public abstract Object[] toArray(T var1);

    protected Object[] newArray(int length) {
        return (Object[])Array.newInstance(this.next().type(), length);
    }

    public String tag() {
        return "tensor";
    }

    public Item mold(T tensor) {
        if (tensor != null) {
            Object[] us = this.toArray(tensor);
            Record header = Record.create((int)us.length);
            TensorForm<V> next = this.next();
            for (int i = 0; i < us.length; ++i) {
                header.item(next.mold(us[i]));
            }
            return Record.create((int)1).attr(this.tag(), (Value)header);
        }
        return Item.extant();
    }

    public T cast(Item item) {
        Value header = item.toValue().header(this.tag());
        if (header.isDefined()) {
            int n = header.length();
            Object[] us = this.newArray(n);
            TensorForm<V> next = this.next();
            for (int i = 0; i < n; ++i) {
                Object u = next.cast(header.getItem(i));
                if (u == null) {
                    u = next.unit();
                }
                us[i] = u;
            }
            return this.fromArray(us);
        }
        return null;
    }

    @Override
    public T fromTensor(TensorDims vd, float[] vs, int vi) {
        Object[] us = this.newArray(vd.size);
        TensorForm<V> next = this.next();
        for (int i = 0; i < vd.size; ++i) {
            Object u = next.fromTensor(vd.next, vs, vi);
            if (u == null) {
                u = next.unit();
            }
            us[i] = u;
            vi += vd.stride;
        }
        return this.fromArray(us);
    }

    @Override
    public T fromTensor(TensorDims vd, double[] vs, int vi) {
        Object[] us = this.newArray(vd.size);
        TensorForm<V> next = this.next();
        for (int i = 0; i < vd.size; ++i) {
            Object u = next.fromTensor(vd.next, vs, vi);
            if (u == null) {
                u = next.unit();
            }
            us[i] = u;
            vi += vd.stride;
        }
        return this.fromArray(us);
    }

    @Override
    public void toTensor(T u, TensorDims vd, float[] vs, int vi) {
        Object[] us = this.toArray(u);
        if (us.length != vd.size) {
            throw new DimensionException();
        }
        TensorForm<V> next = this.next();
        for (int i = 0; i < vd.size; ++i) {
            next.toTensor(us[i], vd.next, vs, vi);
            vi += vd.stride;
        }
    }

    @Override
    public void toTensor(T u, TensorDims vd, double[] vs, int vi) {
        Object[] us = this.toArray(u);
        if (us.length != vd.size) {
            throw new DimensionException();
        }
        TensorForm<V> next = this.next();
        for (int i = 0; i < vd.size; ++i) {
            next.toTensor(us[i], vd.next, vs, vi);
            vi += vd.stride;
        }
    }

    @Override
    public Item moldTensor(TensorDims vd, float[] vs, int vi) {
        Record header = Record.create((int)vd.size);
        TensorForm<V> next = this.next();
        for (int i = 0; i < vd.size; ++i) {
            header.item(next.moldTensor(vd.next, vs, vi));
            vi += vd.stride;
        }
        return Record.create((int)1).attr(this.tag(), (Value)header);
    }

    @Override
    public Item moldTensor(TensorDims vd, double[] vs, int vi) {
        Record header = Record.create((int)vd.size);
        TensorForm<V> next = this.next();
        for (int i = 0; i < vd.size; ++i) {
            header.item(next.moldTensor(vd.next, vs, vi));
            vi += vd.stride;
        }
        return Record.create((int)1).attr(this.tag(), (Value)header);
    }

    @Override
    public void castTensor(Item item, TensorDims vd, float[] vs, int vi) {
        Value header = item.toValue().header(this.tag());
        if (!header.isDefined() || header.length() != vd.size) {
            throw new DimensionException();
        }
        TensorForm<V> next = this.next();
        for (int i = 0; i < vd.size; ++i) {
            next.castTensor(header.getItem(i), vd.next, vs, vi);
            vi += vd.stride;
        }
    }

    @Override
    public void castTensor(Item item, TensorDims vd, double[] vs, int vi) {
        Value header = item.toValue().header(this.tag());
        if (!header.isDefined() || header.length() != vd.size) {
            throw new DimensionException();
        }
        TensorForm<V> next = this.next();
        for (int i = 0; i < vd.size; ++i) {
            next.castTensor(header.getItem(i), vd.next, vs, vi);
            vi += vd.stride;
        }
    }

    public static <V> TensorArrayForm<V[], V> from(TensorForm<V> next) {
        return new TensorArrayIdentityForm<V>(next);
    }
}

