/*
 * Decompiled with CFR 0.152.
 */
package swim.deflate;

final class Adler32 {
    static final int BASE = 65521;
    static final int NMAX = 5552;

    private Adler32() {
    }

    static int adler32(int adler, byte[] buffer, int offset, int length) {
        int sum2 = adler >>> 16 & 0xFFFF;
        adler &= 0xFFFF;
        if (length == 1) {
            if ((adler += buffer[0]) >= 65521) {
                adler -= 65521;
            }
            if ((sum2 += adler) >= 65521) {
                sum2 -= 65521;
            }
            return adler | sum2 << 16;
        }
        if (buffer == null) {
            return 1;
        }
        if (length < 16) {
            while (length-- != 0) {
                sum2 += (adler += buffer[offset++]);
            }
            if (adler >= 65521) {
                adler -= 65521;
            }
            return adler | (sum2 %= 65521) << 16;
        }
        while (length >= 5552) {
            length -= 5552;
            int n = 347;
            do {
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
            } while (--n != 0);
            adler %= 65521;
            sum2 %= 65521;
        }
        if (length != 0) {
            while (length >= 16) {
                length -= 16;
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
                sum2 += (adler += buffer[offset++]);
            }
            while (length-- != 0) {
                sum2 += (adler += buffer[offset++]);
            }
            adler %= 65521;
            sum2 %= 65521;
        }
        return adler | sum2 << 16;
    }
}

