/*
 * Decompiled with CFR 0.152.
 */
package swim.protobuf;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;
import swim.protobuf.ProtobufDecoder;

final class Fixed64Decoder<V>
extends Decoder<V> {
    final ProtobufDecoder<?, V> protobuf;
    final long value;
    final int shift;

    Fixed64Decoder(ProtobufDecoder<?, V> protobuf, long value, int shift) {
        this.protobuf = protobuf;
        this.value = value;
        this.shift = shift;
    }

    public Decoder<V> feed(InputBuffer input) {
        return Fixed64Decoder.decode(input, this.protobuf, this.value, this.shift);
    }

    static <V> Decoder<V> decode(InputBuffer input, ProtobufDecoder<?, V> protobuf, long value, int shift) {
        while (input.isCont()) {
            value |= (long)input.head() << shift;
            input = input.step();
            if (shift != 0) {
                shift -= 8;
                continue;
            }
            return Fixed64Decoder.done(protobuf.fixed(value));
        }
        if (input.isDone()) {
            return Fixed64Decoder.error((Throwable)new DecoderException("incomplete"));
        }
        if (input.isError()) {
            return Fixed64Decoder.error((Throwable)input.trap());
        }
        return new Fixed64Decoder<V>(protobuf, value, shift);
    }

    static <V> Decoder<V> decode(InputBuffer input, ProtobufDecoder<?, V> protobuf) {
        return Fixed64Decoder.decode(input, protobuf, 0L, 56);
    }
}

