/*
 * Decompiled with CFR 0.152.
 */
package swim.cli;

import swim.api.downlink.EventDownlink;
import swim.api.ref.WarpRef;
import swim.api.warp.WarpDownlink;
import swim.args.Arg;
import swim.args.Cmd;
import swim.args.Opt;
import swim.cli.DownlinkGetter;
import swim.cli.DownlinkLogger;
import swim.uri.Uri;

public class CliClient {
    protected final WarpRef warp;

    public CliClient(WarpRef warp) {
        this.warp = warp;
    }

    public final WarpRef warp() {
        return this.warp;
    }

    public String name() {
        return "swim-cli";
    }

    public Cmd mainCmd() {
        return Cmd.create((String)this.name()).cmd(this.linkCmd()).cmd(this.syncCmd()).cmd(this.getCmd()).cmd(this.reflectCmd()).helpCmd();
    }

    public Cmd linkCmd() {
        return Cmd.create((String)"link").desc("stream changes to a lane create a remote node").opt(Opt.create((String)"host").flag('h').arg("hostUri").desc("remote host to link")).opt(Opt.create((String)"node").flag('n').arg("nodeUri").desc("remote node to link")).opt(Opt.create((String)"lane").flag('l').arg("laneUri").desc("lane to link")).opt(Opt.create((String)"format").flag('f').arg("json|recon").desc("event output format")).helpCmd().exec(this::runLinkCmd);
    }

    public Cmd syncCmd() {
        return Cmd.create((String)"sync").desc("stream the current state and changes to a lane create a remote node").opt(Opt.create((String)"host").flag('h').arg("hostUri").desc("remote host to link")).opt(Opt.create((String)"node").flag('n').arg("nodeUri").desc("remote node to link")).opt(Opt.create((String)"lane").flag('l').arg("laneUri").desc("lane to link")).opt(Opt.create((String)"format").flag('f').arg("json|recon").desc("event output format")).helpCmd().exec(this::runSyncCmd);
    }

    public Cmd getCmd() {
        return Cmd.create((String)"get").desc("fetch the current state create a lane create a remote node").opt(Opt.create((String)"host").flag('h').arg("hostUri").desc("remote host to link")).opt(Opt.create((String)"node").flag('n').arg("nodeUri").desc("remote node to link")).opt(Opt.create((String)"lane").flag('l').arg("laneUri").desc("lane to link")).opt(Opt.create((String)"format").flag('f').arg("json|recon").desc("event output format")).helpCmd().exec(this::runGetCmd);
    }

    public Cmd reflectCmd() {
        return Cmd.create((String)"reflect").desc("stream introspection metadata").opt(Opt.create((String)"edge").flag('e').arg("edgeUri").desc("endpoint to introspect")).opt(Opt.create((String)"mesh").flag('m').arg(Arg.create((String)"meshUri").optional(true)).desc("introspect default or specified mesh")).opt(Opt.create((String)"part").flag('p').arg(Arg.create((String)"partKey").optional(true)).desc("introspect default or specified partition")).opt(Opt.create((String)"host").flag('h').arg(Arg.create((String)"hostUri").optional(true)).desc("introspect default or specified host")).opt(Opt.create((String)"node").flag('n').arg("nodeUri").desc("introspect specified node")).opt(Opt.create((String)"lane").flag('l').arg("laneUri").desc("introspect specified lane")).opt(Opt.create((String)"link").flag('k').desc("introspect link behavior")).opt(Opt.create((String)"router").flag('r').desc("introspect router behavior")).opt(Opt.create((String)"data").desc("introspect data behavior")).opt(Opt.create((String)"system").desc("introspect system behavior")).opt(Opt.create((String)"process").desc("introspect process behavior")).opt(Opt.create((String)"stats").flag('s').desc("stream introspection statistics")).opt(Opt.create((String)"format").flag('f').arg("json|recon").desc("event output format")).cmd(this.reflectLogCmd()).helpCmd().exec(this::runReflectCmd);
    }

    public Cmd reflectLogCmd() {
        return Cmd.create((String)"log").desc("stream log events").opt(Opt.create((String)"trace").flag('t').desc("stream trace log messages")).opt(Opt.create((String)"debug").flag('d').desc("stream debug log messages")).opt(Opt.create((String)"info").flag('i').desc("stream info log messages")).opt(Opt.create((String)"warn").flag('w').desc("stream warning log messages")).opt(Opt.create((String)"error").flag('e').desc("stream error log messages")).helpCmd().exec(this::runReflectLogCmd);
    }

    public void runLinkCmd(Cmd cmd) {
        WarpDownlink downlink = this.downlink(cmd).keepSynced(false);
        DownlinkLogger downlinkLogger = this.downlinkLogger(downlink, cmd);
        downlinkLogger.open();
    }

    public void runSyncCmd(Cmd cmd) {
        WarpDownlink downlink = this.downlink(cmd).keepSynced(true);
        DownlinkLogger downlinkLogger = this.downlinkLogger(downlink, cmd);
        downlinkLogger.open();
    }

    public void runGetCmd(Cmd cmd) {
        WarpDownlink downlink = this.downlink(cmd).keepSynced(true);
        DownlinkGetter downlinkGetter = this.downlinkGetter(downlink, cmd);
        downlinkGetter.open();
    }

    public void runReflectCmd(Cmd cmd) {
        String edgeUri = cmd.getOpt("edge").getValue();
        if (edgeUri != null) {
            String meshUri = cmd.getOpt("mesh").getValue();
            String hostUri = cmd.getOpt("host").getValue();
            String nodeUri = cmd.getOpt("node").getValue();
            String laneUri = cmd.getOpt("lane").getValue();
            if (nodeUri != null) {
                Uri metaNodeUri = meshUri != null ? Uri.parse((String)"swim:meta:mesh").appendedPath(new String[]{meshUri, "node", nodeUri}) : (hostUri != null ? Uri.parse((String)"swim:meta:host").appendedPath(new String[]{hostUri, "node", nodeUri}) : Uri.parse((String)"swim:meta:node").appendedPath(nodeUri));
                if (laneUri != null) {
                    metaNodeUri = metaNodeUri.appendedPath(new String[]{"lane", laneUri});
                    EventDownlink downlink = this.warp.downlink().hostUri(edgeUri).nodeUri(metaNodeUri).laneUri("linkStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((WarpDownlink)downlink, cmd);
                    downlinkLogger.open();
                } else if (cmd.getOpt("link").isDefined()) {
                    EventDownlink downlink = this.warp.downlink().hostUri(edgeUri).nodeUri(metaNodeUri).laneUri("linkStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((WarpDownlink)downlink, cmd);
                    downlinkLogger.open();
                } else {
                    EventDownlink downlink = this.warp.downlink().hostUri(edgeUri).nodeUri(metaNodeUri).laneUri("routerStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((WarpDownlink)downlink, cmd);
                    downlinkLogger.open();
                }
            } else if (hostUri != null) {
                Uri metaNodeUri;
                if (meshUri != null) {
                    metaNodeUri = Uri.parse((String)"swim:meta:mesh").appendedPath(meshUri);
                    if (hostUri != null) {
                        metaNodeUri = metaNodeUri.appendedPath(new String[]{"host", hostUri});
                    }
                } else {
                    metaNodeUri = Uri.parse((String)"swim:meta:host");
                    if (hostUri != null) {
                        metaNodeUri = metaNodeUri.appendedPath(hostUri);
                    }
                }
                if (cmd.getOpt("process").isDefined()) {
                    EventDownlink downlink = this.warp.downlink().hostUri(edgeUri).nodeUri(metaNodeUri).laneUri("processStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((WarpDownlink)downlink, cmd);
                    downlinkLogger.open();
                } else if (cmd.getOpt("system").isDefined()) {
                    EventDownlink downlink = this.warp.downlink().hostUri(edgeUri).nodeUri(metaNodeUri).laneUri("systemStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((WarpDownlink)downlink, cmd);
                    downlinkLogger.open();
                } else if (cmd.getOpt("data").isDefined()) {
                    EventDownlink downlink = this.warp.downlink().hostUri(edgeUri).nodeUri(metaNodeUri).laneUri("dataStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((WarpDownlink)downlink, cmd);
                    downlinkLogger.open();
                } else if (cmd.getOpt("router").isDefined()) {
                    EventDownlink downlink = this.warp.downlink().hostUri(edgeUri).nodeUri(metaNodeUri).laneUri("routerStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((WarpDownlink)downlink, cmd);
                    downlinkLogger.open();
                } else if (cmd.getOpt("link").isDefined()) {
                    EventDownlink downlink = this.warp.downlink().hostUri(edgeUri).nodeUri(metaNodeUri).laneUri("linkStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((WarpDownlink)downlink, cmd);
                    downlinkLogger.open();
                } else {
                    EventDownlink downlink = this.warp.downlink().hostUri(edgeUri).nodeUri(metaNodeUri).laneUri("hostStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((WarpDownlink)downlink, cmd);
                    downlinkLogger.open();
                }
            } else if (meshUri != null) {
                Uri metaNodeUri = Uri.parse((String)"swim:meta:mesh");
                if (meshUri != null) {
                    metaNodeUri = metaNodeUri.appendedPath(meshUri);
                }
                if (cmd.getOpt("process").isDefined()) {
                    EventDownlink downlink = this.warp.downlink().hostUri(edgeUri).nodeUri(metaNodeUri).laneUri("processStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((WarpDownlink)downlink, cmd);
                    downlinkLogger.open();
                } else if (cmd.getOpt("system").isDefined()) {
                    EventDownlink downlink = this.warp.downlink().hostUri(edgeUri).nodeUri(metaNodeUri).laneUri("systemStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((WarpDownlink)downlink, cmd);
                    downlinkLogger.open();
                } else if (cmd.getOpt("data").isDefined()) {
                    EventDownlink downlink = this.warp.downlink().hostUri(edgeUri).nodeUri(metaNodeUri).laneUri("dataStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((WarpDownlink)downlink, cmd);
                    downlinkLogger.open();
                } else if (cmd.getOpt("router").isDefined()) {
                    EventDownlink downlink = this.warp.downlink().hostUri(edgeUri).nodeUri(metaNodeUri).laneUri("routerStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((WarpDownlink)downlink, cmd);
                    downlinkLogger.open();
                } else if (cmd.getOpt("link").isDefined()) {
                    EventDownlink downlink = this.warp.downlink().hostUri(edgeUri).nodeUri(metaNodeUri).laneUri("linkStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((WarpDownlink)downlink, cmd);
                    downlinkLogger.open();
                } else {
                    EventDownlink downlink = this.warp.downlink().hostUri(edgeUri).nodeUri(metaNodeUri).laneUri("meshStats").keepSynced(true);
                    DownlinkLogger downlinkLogger = this.downlinkLogger((WarpDownlink)downlink, cmd);
                    downlinkLogger.open();
                }
            } else if (cmd.getOpt("process").isDefined()) {
                EventDownlink downlink = this.warp.downlink().hostUri(edgeUri).nodeUri("swim:meta:edge").laneUri("processStats").keepSynced(true);
                DownlinkLogger downlinkLogger = this.downlinkLogger((WarpDownlink)downlink, cmd);
                downlinkLogger.open();
            } else if (cmd.getOpt("system").isDefined()) {
                EventDownlink downlink = this.warp.downlink().hostUri(edgeUri).nodeUri("swim:meta:edge").laneUri("systemStats").keepSynced(true);
                DownlinkLogger downlinkLogger = this.downlinkLogger((WarpDownlink)downlink, cmd);
                downlinkLogger.open();
            } else if (cmd.getOpt("data").isDefined()) {
                EventDownlink downlink = this.warp.downlink().hostUri(edgeUri).nodeUri("swim:meta:edge").laneUri("dataStats").keepSynced(true);
                DownlinkLogger downlinkLogger = this.downlinkLogger((WarpDownlink)downlink, cmd);
                downlinkLogger.open();
            } else if (cmd.getOpt("link").isDefined()) {
                EventDownlink downlink = this.warp.downlink().hostUri(edgeUri).nodeUri("swim:meta:edge").laneUri("linkStats").keepSynced(true);
                DownlinkLogger downlinkLogger = this.downlinkLogger((WarpDownlink)downlink, cmd);
                downlinkLogger.open();
            } else {
                EventDownlink downlink = this.warp.downlink().hostUri(edgeUri).nodeUri("swim:meta:edge").laneUri("routerStats").keepSynced(true);
                DownlinkLogger downlinkLogger = this.downlinkLogger((WarpDownlink)downlink, cmd);
                downlinkLogger.open();
            }
        }
    }

    public void runReflectLogCmd(Cmd cmd) {
    }

    protected WarpDownlink downlink(Cmd cmd) {
        return this.warp.downlink().hostUri(cmd.getOpt("host").getValue()).nodeUri(cmd.getOpt("node").getValue()).laneUri(cmd.getOpt("lane").getValue());
    }

    protected DownlinkLogger downlinkLogger(WarpDownlink downlink, Cmd cmd) {
        String format = cmd.getOpt("format").getValue();
        return new DownlinkLogger(downlink, format);
    }

    protected DownlinkGetter downlinkGetter(WarpDownlink downlink, Cmd cmd) {
        String format = cmd.getOpt("format").getValue();
        return new DownlinkGetter(downlink, format);
    }
}

