/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import java.nio.ByteBuffer;
import swim.codec.Base16IntegerWriter;
import swim.codec.Base16Parser;
import swim.codec.Base16Writer;
import swim.codec.Binary;
import swim.codec.Format;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Unicode;
import swim.codec.Writer;

public final class Base16 {
    private static Base16 lowercase;
    private static Base16 uppercase;
    final String alphabet;

    Base16(String alphabet) {
        this.alphabet = alphabet;
    }

    public static Base16 lowercase() {
        if (lowercase == null) {
            lowercase = new Base16("0123456789abcdef");
        }
        return lowercase;
    }

    public static Base16 uppercase() {
        if (uppercase == null) {
            uppercase = new Base16("0123456789ABCDEF");
        }
        return uppercase;
    }

    public static boolean isDigit(int c) {
        return c >= 48 && c <= 57 || c >= 65 && c <= 70 || c >= 97 && c <= 102;
    }

    public static int decodeDigit(int c) {
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        if (c >= 65 && c <= 70) {
            return 10 + (c - 65);
        }
        if (c >= 97 && c <= 102) {
            return 10 + (c - 97);
        }
        Output<String> message = Unicode.stringOutput();
        message.write("Invalid base-16 digit: ");
        Format.debugChar(c, message);
        throw new IllegalArgumentException(message.bind());
    }

    public static void writeQuantum(int c1, int c2, Output<?> output) {
        int x = Base16.decodeDigit(c1);
        int y = Base16.decodeDigit(c2);
        output.write(x << 4 | y);
    }

    public static <O> Parser<O> parser(Output<O> output) {
        return new Base16Parser<O>(output);
    }

    public static <O> Parser<O> parse(Input input, Output<O> output) {
        return Base16Parser.parse(input, output);
    }

    public static Parser<byte[]> parseByteArray(Input input) {
        return Base16Parser.parse(input, Binary.byteArrayOutput());
    }

    public static Parser<ByteBuffer> parseByteBuffer(Input input) {
        return Base16Parser.parse(input, Binary.byteBufferOutput());
    }

    public String alphabet() {
        return this.alphabet;
    }

    public char encodeDigit(int b) {
        return this.alphabet.charAt(b);
    }

    public Writer<byte[], ?> byteArrayWriter() {
        return new Base16Writer(this);
    }

    public Writer<?, byte[]> byteArrayWriter(byte[] input) {
        return new Base16Writer((Object)input, input, this);
    }

    public Writer<ByteBuffer, ?> byteBufferWriter() {
        return new Base16Writer(this);
    }

    public Writer<?, ByteBuffer> byteBufferWriter(ByteBuffer input) {
        return new Base16Writer((Object)input, input, this);
    }

    public Writer<?, ?> writeByteArray(byte[] input, Output<?> output) {
        return Base16Writer.write(output, input, this);
    }

    public Writer<?, ?> writeByteBuffer(ByteBuffer input, Output<?> output) {
        return Base16Writer.write(output, input, this);
    }

    public Writer<?, ?> writeInt(int input, Output<?> output, int width) {
        return Base16IntegerWriter.write(output, null, input, width, this, false);
    }

    public Writer<?, ?> writeInt(int input, Output<?> output) {
        return Base16IntegerWriter.write(output, null, input, 0, this, false);
    }

    public Writer<?, ?> writeLong(long input, Output<?> output, int width) {
        return Base16IntegerWriter.write(output, null, input, width, this, false);
    }

    public Writer<?, ?> writeLong(long input, Output<?> output) {
        return Base16IntegerWriter.write(output, null, input, 0, this, false);
    }

    public Writer<?, ?> writeIntLiteral(int input, Output<?> output, int width) {
        return Base16IntegerWriter.write(output, null, input, width, this, true);
    }

    public Writer<?, ?> writeIntLiteral(int input, Output<?> output) {
        return Base16IntegerWriter.write(output, null, input, 0, this, true);
    }

    public Writer<?, ?> writeLongLiteral(long input, Output<?> output, int width) {
        return Base16IntegerWriter.write(output, null, input, width, this, true);
    }

    public Writer<?, ?> writeLongLiteral(long input, Output<?> output) {
        return Base16IntegerWriter.write(output, null, input, 0, this, true);
    }
}

