/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.ParserException;

final class ByteParser<O>
extends Parser<O> {
    final Output<O> output;

    ByteParser(Output<O> output) {
        this.output = output;
    }

    static <O> Parser<O> parse(Input input, Output<O> output) {
        while (input.isCont() && output.isCont()) {
            output = output.write(input.head());
            input = input.step();
        }
        if (input.isDone()) {
            return ByteParser.done(output.bind());
        }
        if (input.isError()) {
            return ByteParser.error(input.trap());
        }
        if (output.isDone()) {
            return ByteParser.error(new ParserException("incomplete"));
        }
        if (output.isError()) {
            return ByteParser.error(output.trap());
        }
        return new ByteParser<O>(output);
    }

    @Override
    public Parser<O> feed(Input input) {
        Output<O> output = this.output;
        while (input.isCont() && output.isCont()) {
            output = output.write(input.head());
            input = input.step();
        }
        if (input.isDone()) {
            return ByteParser.done(output.bind());
        }
        if (input.isError()) {
            return ByteParser.error(input.trap());
        }
        if (output.isDone()) {
            return ByteParser.error(new ParserException("incomplete"));
        }
        if (output.isError()) {
            return ByteParser.error(output.trap());
        }
        return this;
    }
}

