/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import java.math.BigDecimal;
import java.math.BigInteger;
import swim.codec.BigIntegerParser;
import swim.codec.DecimalParser;
import swim.codec.Diagnostic;
import swim.codec.HexadecimalParser;
import swim.codec.Input;
import swim.codec.Parser;

final class NumberParser
extends Parser<Number> {
    final int sign;
    final long value;
    final int mode;
    final int step;

    NumberParser(int sign, long value, int mode, int step) {
        this.sign = sign;
        this.value = value;
        this.mode = mode;
        this.step = step;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<Number> parse(Input input, int sign, long value, int mode, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (c == 45) {
                    input = input.step();
                    sign = -1;
                }
                step = 2;
            } else if (input.isDone()) {
                return NumberParser.error(Diagnostic.expected("number", input));
            }
        }
        if (step == 2) {
            if (input.isCont()) {
                c = input.head();
                if (c == 48) {
                    input = input.step();
                    step = 4;
                } else {
                    if (c < 49 || c > 57) return NumberParser.error(Diagnostic.expected("digit", input));
                    input = input.step();
                    value = sign * (c - 48);
                    step = 3;
                }
            } else if (input.isDone()) {
                return NumberParser.error(Diagnostic.expected("digit", input));
            }
        }
        if (step == 3) {
            while (input.isCont() && (c = input.head()) >= 48 && c <= 57) {
                long newValue = 10L * value + (long)(sign * (c - 48));
                if (value >> 63 != newValue >> 63) return BigIntegerParser.parse(input, sign, BigInteger.valueOf(value));
                value = newValue;
                input = input.step();
            }
            if (input.isCont()) {
                step = 4;
            } else if (input.isDone()) {
                return NumberParser.done(NumberParser.valueOf(value));
            }
        }
        if (step == 4) {
            if (input.isCont()) {
                c = input.head();
                if (mode > 0 && c == 46 || mode > 1 && (c == 69 || c == 101)) {
                    return DecimalParser.parse(input, sign, value, mode);
                }
                if (c != 120 || sign <= 0 || value != 0L) return NumberParser.done(value);
                input = input.step();
                return HexadecimalParser.parse(input);
            }
            if (input.isDone()) {
                return NumberParser.done(value);
            }
        }
        if (!input.isError()) return new NumberParser(sign, value, mode, step);
        return NumberParser.error(input.trap());
    }

    static Parser<Number> parseNumber(Input input) {
        return NumberParser.parse(input, 1, 0L, 2, 1);
    }

    static Parser<Number> parseDecimal(Input input) {
        return NumberParser.parse(input, 1, 0L, 1, 1);
    }

    static Parser<Number> parseInteger(Input input) {
        return NumberParser.parse(input, 1, 0L, 0, 1);
    }

    static Parser<Number> numberParser() {
        return new NumberParser(1, 0L, 2, 1);
    }

    static Parser<Number> decimalParser() {
        return new NumberParser(1, 0L, 1, 1);
    }

    static Parser<Number> integerParser() {
        return new NumberParser(1, 0L, 0, 1);
    }

    public static Number valueOf(long value) {
        if ((long)((int)value) == value) {
            return (int)value;
        }
        return value;
    }

    public static Number valueOf(String value) {
        try {
            long longValue = Long.parseLong(value);
            if ((long)((int)longValue) == longValue) {
                return (int)longValue;
            }
            return longValue;
        }
        catch (NumberFormatException e1) {
            try {
                double doubleValue = Double.parseDouble(value);
                if ((double)((float)doubleValue) == doubleValue) {
                    return Float.valueOf((float)doubleValue);
                }
                return doubleValue;
            }
            catch (NumberFormatException e2) {
                return new BigDecimal(value);
            }
        }
    }

    @Override
    public Parser<Number> feed(Input input) {
        return NumberParser.parse(input, this.sign, this.value, this.mode, this.step);
    }
}

