/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Output;
import swim.codec.OutputSettings;

final class StringOutput
extends Output<String> {
    final StringBuilder builder;
    OutputSettings settings;

    StringOutput(StringBuilder builder, OutputSettings settings) {
        this.builder = builder;
        this.settings = settings;
    }

    @Override
    public boolean isCont() {
        return true;
    }

    @Override
    public boolean isFull() {
        return false;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isPart() {
        return false;
    }

    @Override
    public Output<String> isPart(boolean isPart) {
        return this;
    }

    @Override
    public Output<String> write(int codePoint) {
        this.builder.appendCodePoint(codePoint);
        return this;
    }

    @Override
    public Output<String> write(String string) {
        this.builder.append(string);
        return this;
    }

    @Override
    public Output<String> writeln(String string) {
        this.builder.append(string).append(this.settings.lineSeparator);
        return this;
    }

    @Override
    public Output<String> writeln() {
        this.builder.append(this.settings.lineSeparator);
        return this;
    }

    @Override
    public OutputSettings settings() {
        return this.settings;
    }

    @Override
    public Output<String> settings(OutputSettings settings) {
        this.settings = settings;
        return this;
    }

    @Override
    public String bind() {
        return this.builder.toString();
    }

    @Override
    public Output<String> clone() {
        return new StringOutput(new StringBuilder(this.builder.toString()), this.settings);
    }

    public String toString() {
        return this.builder.toString();
    }
}

