/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Base10IntegerWriter;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;

final class StringWriter
extends Writer<Object, Object> {
    final Object value;
    final String input;
    final int index;

    StringWriter(Object value, String input, int index) {
        this.value = value;
        this.input = input;
        this.index = index;
    }

    StringWriter(Object value, Object input) {
        this(value, input != null ? input.toString() : "null", 0);
    }

    StringWriter() {
        this(null, "", 0);
    }

    static Writer<Object, Object> write(Output<?> output, Object value, String input, int index) {
        int length;
        int n = length = input != null ? input.length() : 0;
        while (index < length && output.isCont()) {
            output = output.write(input.codePointAt(index));
            index = input.offsetByCodePoints(index, 1);
        }
        if (index == length) {
            return StringWriter.done(value);
        }
        if (output.isDone()) {
            return StringWriter.error(new WriterException("truncated"));
        }
        if (output.isError()) {
            return StringWriter.error(output.trap());
        }
        return new StringWriter(value, input, index);
    }

    static Writer<Object, Object> write(Output<?> output, Object value, Object input) {
        if (input instanceof Integer) {
            return Base10IntegerWriter.write(output, value, ((Integer)input).longValue());
        }
        if (input instanceof Long) {
            return Base10IntegerWriter.write(output, value, (Long)input);
        }
        return StringWriter.write(output, value, input != null ? input.toString() : "null", 0);
    }

    @Override
    public Writer<Object, Object> feed(Object input) {
        if (input instanceof Integer) {
            return new Base10IntegerWriter(input, ((Integer)input).longValue());
        }
        if (input instanceof Long) {
            return new Base10IntegerWriter(input, (Long)input);
        }
        return new StringWriter(input, input);
    }

    @Override
    public Writer<Object, Object> pull(Output<?> output) {
        return StringWriter.write(output, this.value, this.input, this.index);
    }
}

